/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOptionListCopier;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerTlsCertificateRenewalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerTlsCertificateRenewalSummary> {
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("renewalStatus").getter(LoadBalancerTlsCertificateRenewalSummary.getter(LoadBalancerTlsCertificateRenewalSummary::renewalStatusAsString)).setter(LoadBalancerTlsCertificateRenewalSummary.setter(Builder::renewalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatus").build()}).build();
    private static final SdkField<List<LoadBalancerTlsCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainValidationOptions").getter(LoadBalancerTlsCertificateRenewalSummary.getter(LoadBalancerTlsCertificateRenewalSummary::domainValidationOptions)).setter(LoadBalancerTlsCertificateRenewalSummary.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerTlsCertificateDomainValidationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_STATUS_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String renewalStatus;
    private final List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions;

    private LoadBalancerTlsCertificateRenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    public final LoadBalancerTlsCertificateRenewalStatus renewalStatus() {
        return LoadBalancerTlsCertificateRenewalStatus.fromValue(this.renewalStatus);
    }

    public final String renewalStatusAsString() {
        return this.renewalStatus;
    }

    public final boolean hasDomainValidationOptions() {
        return this.domainValidationOptions != null && !(this.domainValidationOptions instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationOptions() ? this.domainValidationOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateRenewalSummary)) {
            return false;
        }
        LoadBalancerTlsCertificateRenewalSummary other = (LoadBalancerTlsCertificateRenewalSummary)obj;
        return Objects.equals(this.renewalStatusAsString(), other.renewalStatusAsString()) && this.hasDomainValidationOptions() == other.hasDomainValidationOptions() && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerTlsCertificateRenewalSummary").add("RenewalStatus", (Object)this.renewalStatusAsString()).add("DomainValidationOptions", this.hasDomainValidationOptions() ? this.domainValidationOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "renewalStatus": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusAsString()));
            }
            case "domainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateRenewalSummary, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateRenewalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renewalStatus;
        private List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateRenewalSummary model) {
            this.renewalStatus(model.renewalStatus);
            this.domainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return this.renewalStatus;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus == null ? null : renewalStatus.toString());
            return this;
        }

        public final List<LoadBalancerTlsCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            List<LoadBalancerTlsCertificateDomainValidationOption.Builder> result = LoadBalancerTlsCertificateDomainValidationOptionListCopier.copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(Collection<LoadBalancerTlsCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier.copyFromBuilder(domainValidationOptions);
        }

        @Override
        public final Builder domainValidationOptions(Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (LoadBalancerTlsCertificateDomainValidationOption)((LoadBalancerTlsCertificateDomainValidationOption.Builder)LoadBalancerTlsCertificateDomainValidationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LoadBalancerTlsCertificateRenewalSummary build() {
            return new LoadBalancerTlsCertificateRenewalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerTlsCertificateRenewalSummary> {
        public Builder renewalStatus(String var1);

        public Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus var1);

        public Builder domainValidationOptions(Collection<LoadBalancerTlsCertificateDomainValidationOption> var1);

        public Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption ... var1);

        public Builder domainValidationOptions(Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder> ... var1);
    }
}

