/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceSnapshotState {
    PENDING("pending"),
    ERROR("error"),
    AVAILABLE("available"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceSnapshotState> VALUE_MAP;
    private final String value;

    private InstanceSnapshotState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceSnapshotState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceSnapshotState> knownValues() {
        EnumSet<InstanceSnapshotState> knownValues = EnumSet.allOf(InstanceSnapshotState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceSnapshotState.class, InstanceSnapshotState::toString);
    }
}

