/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Bundle;

final class BundleListCopier {
    BundleListCopier() {
    }

    static List<Bundle> copy(Collection<? extends Bundle> bundleListParam) {
        Object list;
        if (bundleListParam == null || bundleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            bundleListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Bundle> copyFromBuilder(Collection<? extends Bundle.Builder> bundleListParam) {
        Object list;
        if (bundleListParam == null || bundleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            bundleListParam.forEach(entry -> {
                Bundle member = entry == null ? null : (Bundle)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Bundle.Builder> copyToBuilder(Collection<? extends Bundle> bundleListParam) {
        Object list;
        if (bundleListParam == null || bundleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            bundleListParam.forEach(entry -> {
                Bundle.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

