/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CostEstimate;
import software.amazon.awssdk.services.lightsail.model.CostEstimatesCopier;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceBudgetEstimate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceBudgetEstimate> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(ResourceBudgetEstimate.getter(ResourceBudgetEstimate::resourceName)).setter(ResourceBudgetEstimate.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResourceBudgetEstimate.getter(ResourceBudgetEstimate::resourceTypeAsString)).setter(ResourceBudgetEstimate.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<CostEstimate>> COST_ESTIMATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("costEstimates").getter(ResourceBudgetEstimate.getter(ResourceBudgetEstimate::costEstimates)).setter(ResourceBudgetEstimate.setter(Builder::costEstimates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costEstimates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostEstimate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ResourceBudgetEstimate.getter(ResourceBudgetEstimate::startTime)).setter(ResourceBudgetEstimate.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ResourceBudgetEstimate.getter(ResourceBudgetEstimate::endTime)).setter(ResourceBudgetEstimate.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, COST_ESTIMATES_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceName;
    private final String resourceType;
    private final List<CostEstimate> costEstimates;
    private final Instant startTime;
    private final Instant endTime;

    private ResourceBudgetEstimate(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.costEstimates = builder.costEstimates;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasCostEstimates() {
        return this.costEstimates != null && !(this.costEstimates instanceof SdkAutoConstructList);
    }

    public final List<CostEstimate> costEstimates() {
        return this.costEstimates;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostEstimates() ? this.costEstimates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceBudgetEstimate)) {
            return false;
        }
        ResourceBudgetEstimate other = (ResourceBudgetEstimate)obj;
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasCostEstimates() == other.hasCostEstimates() && Objects.equals(this.costEstimates(), other.costEstimates()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceBudgetEstimate").add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceTypeAsString()).add("CostEstimates", this.hasCostEstimates() ? this.costEstimates() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "costEstimates": {
                return Optional.ofNullable(clazz.cast(this.costEstimates()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceBudgetEstimate, T> g) {
        return obj -> g.apply((ResourceBudgetEstimate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String resourceType;
        private List<CostEstimate> costEstimates = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceBudgetEstimate model) {
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.costEstimates(model.costEstimates);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<CostEstimate.Builder> getCostEstimates() {
            List<CostEstimate.Builder> result = CostEstimatesCopier.copyToBuilder(this.costEstimates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostEstimates(Collection<CostEstimate.BuilderImpl> costEstimates) {
            this.costEstimates = CostEstimatesCopier.copyFromBuilder(costEstimates);
        }

        @Override
        public final Builder costEstimates(Collection<CostEstimate> costEstimates) {
            this.costEstimates = CostEstimatesCopier.copy(costEstimates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costEstimates(CostEstimate ... costEstimates) {
            this.costEstimates(Arrays.asList(costEstimates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costEstimates(Consumer<CostEstimate.Builder> ... costEstimates) {
            this.costEstimates(Stream.of(costEstimates).map(c -> (CostEstimate)((CostEstimate.Builder)CostEstimate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public ResourceBudgetEstimate build() {
            return new ResourceBudgetEstimate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceBudgetEstimate> {
        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder costEstimates(Collection<CostEstimate> var1);

        public Builder costEstimates(CostEstimate ... var1);

        public Builder costEstimates(Consumer<CostEstimate.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

