/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LoadBalancerState {
    ACTIVE("active"),
    PROVISIONING("provisioning"),
    ACTIVE_IMPAIRED("active_impaired"),
    FAILED("failed"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LoadBalancerState> VALUE_MAP;
    private final String value;

    private LoadBalancerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoadBalancerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoadBalancerState> knownValues() {
        EnumSet<LoadBalancerState> knownValues = EnumSet.allOf(LoadBalancerState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LoadBalancerState.class, LoadBalancerState::toString);
    }
}

