/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerServiceMetricName {
    CPU_UTILIZATION("CPUUtilization"),
    MEMORY_UTILIZATION("MemoryUtilization"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerServiceMetricName> VALUE_MAP;
    private final String value;

    private ContainerServiceMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerServiceMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerServiceMetricName> knownValues() {
        EnumSet<ContainerServiceMetricName> knownValues = EnumSet.allOf(ContainerServiceMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerServiceMetricName.class, ContainerServiceMetricName::toString);
    }
}

