/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachedDisk
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttachedDisk> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(AttachedDisk.getter(AttachedDisk::path)).setter(AttachedDisk.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sizeInGb").getter(AttachedDisk.getter(AttachedDisk::sizeInGb)).setter(AttachedDisk.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, SIZE_IN_GB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String path;
    private final Integer sizeInGb;

    private AttachedDisk(BuilderImpl builder) {
        this.path = builder.path;
        this.sizeInGb = builder.sizeInGb;
    }

    public final String path() {
        return this.path;
    }

    public final Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachedDisk)) {
            return false;
        }
        AttachedDisk other = (AttachedDisk)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.sizeInGb(), other.sizeInGb());
    }

    public final String toString() {
        return ToString.builder((String)"AttachedDisk").add("Path", (Object)this.path()).add("SizeInGb", (Object)this.sizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachedDisk, T> g) {
        return obj -> g.apply((AttachedDisk)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachedDisk model) {
            this.path(model.path);
            this.sizeInGb(model.sizeInGb);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        @Transient
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public AttachedDisk build() {
            return new AttachedDisk(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttachedDisk> {
        public Builder path(String var1);

        public Builder sizeInGb(Integer var1);
    }
}

