/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.BucketBundle;
import software.amazon.awssdk.services.lightsail.model.BucketBundleListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketBundlesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetBucketBundlesResponse> {
    private static final SdkField<List<BucketBundle>> BUNDLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bundles").getter(GetBucketBundlesResponse.getter(GetBucketBundlesResponse::bundles)).setter(GetBucketBundlesResponse.setter(Builder::bundles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BucketBundle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD));
    private final List<BucketBundle> bundles;

    private GetBucketBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
    }

    public final boolean hasBundles() {
        return this.bundles != null && !(this.bundles instanceof SdkAutoConstructList);
    }

    public final List<BucketBundle> bundles() {
        return this.bundles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundles() ? this.bundles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketBundlesResponse)) {
            return false;
        }
        GetBucketBundlesResponse other = (GetBucketBundlesResponse)((Object)obj);
        return this.hasBundles() == other.hasBundles() && Objects.equals(this.bundles(), other.bundles());
    }

    public final String toString() {
        return ToString.builder((String)"GetBucketBundlesResponse").add("Bundles", this.hasBundles() ? this.bundles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundles": {
                return Optional.ofNullable(clazz.cast(this.bundles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketBundlesResponse, T> g) {
        return obj -> g.apply((GetBucketBundlesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<BucketBundle> bundles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketBundlesResponse model) {
            super(model);
            this.bundles(model.bundles);
        }

        public final List<BucketBundle.Builder> getBundles() {
            List<BucketBundle.Builder> result = BucketBundleListCopier.copyToBuilder(this.bundles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder bundles(Collection<BucketBundle> bundles) {
            this.bundles = BucketBundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(BucketBundle ... bundles) {
            this.bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<BucketBundle.Builder> ... bundles) {
            this.bundles(Stream.of(bundles).map(c -> (BucketBundle)((BucketBundle.Builder)BucketBundle.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBundles(Collection<BucketBundle.BuilderImpl> bundles) {
            this.bundles = BucketBundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public GetBucketBundlesResponse build() {
            return new GetBucketBundlesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketBundlesResponse> {
        public Builder bundles(Collection<BucketBundle> var1);

        public Builder bundles(BucketBundle ... var1);

        public Builder bundles(Consumer<BucketBundle.Builder> ... var1);
    }
}

