/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AccessKey;
import software.amazon.awssdk.services.lightsail.model.AccessKeyListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketAccessKeysResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetBucketAccessKeysResponse> {
    private static final SdkField<List<AccessKey>> ACCESS_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessKeys").getter(GetBucketAccessKeysResponse.getter(GetBucketAccessKeysResponse::accessKeys)).setter(GetBucketAccessKeysResponse.setter(Builder::accessKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEYS_FIELD));
    private final List<AccessKey> accessKeys;

    private GetBucketAccessKeysResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeys = builder.accessKeys;
    }

    public final boolean hasAccessKeys() {
        return this.accessKeys != null && !(this.accessKeys instanceof SdkAutoConstructList);
    }

    public final List<AccessKey> accessKeys() {
        return this.accessKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessKeys() ? this.accessKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAccessKeysResponse)) {
            return false;
        }
        GetBucketAccessKeysResponse other = (GetBucketAccessKeysResponse)((Object)obj);
        return this.hasAccessKeys() == other.hasAccessKeys() && Objects.equals(this.accessKeys(), other.accessKeys());
    }

    public final String toString() {
        return ToString.builder((String)"GetBucketAccessKeysResponse").add("AccessKeys", this.hasAccessKeys() ? this.accessKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessKeys": {
                return Optional.ofNullable(clazz.cast(this.accessKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketAccessKeysResponse, T> g) {
        return obj -> g.apply((GetBucketAccessKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<AccessKey> accessKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAccessKeysResponse model) {
            super(model);
            this.accessKeys(model.accessKeys);
        }

        public final List<AccessKey.Builder> getAccessKeys() {
            List<AccessKey.Builder> result = AccessKeyListCopier.copyToBuilder(this.accessKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder accessKeys(Collection<AccessKey> accessKeys) {
            this.accessKeys = AccessKeyListCopier.copy(accessKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeys(AccessKey ... accessKeys) {
            this.accessKeys(Arrays.asList(accessKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeys(Consumer<AccessKey.Builder> ... accessKeys) {
            this.accessKeys(Stream.of(accessKeys).map(c -> (AccessKey)((AccessKey.Builder)AccessKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessKeys(Collection<AccessKey.BuilderImpl> accessKeys) {
            this.accessKeys = AccessKeyListCopier.copyFromBuilder(accessKeys);
        }

        @Override
        public GetBucketAccessKeysResponse build() {
            return new GetBucketAccessKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketAccessKeysResponse> {
        public Builder accessKeys(Collection<AccessKey> var1);

        public Builder accessKeys(AccessKey ... var1);

        public Builder accessKeys(Consumer<AccessKey.Builder> ... var1);
    }
}

