/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthReason;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceHealthSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceHealthSummary> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(InstanceHealthSummary.getter(InstanceHealthSummary::instanceName)).setter(InstanceHealthSummary.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> INSTANCE_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceHealth").getter(InstanceHealthSummary.getter(InstanceHealthSummary::instanceHealthAsString)).setter(InstanceHealthSummary.setter(Builder::instanceHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceHealth").build()}).build();
    private static final SdkField<String> INSTANCE_HEALTH_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceHealthReason").getter(InstanceHealthSummary.getter(InstanceHealthSummary::instanceHealthReasonAsString)).setter(InstanceHealthSummary.setter(Builder::instanceHealthReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceHealthReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, INSTANCE_HEALTH_FIELD, INSTANCE_HEALTH_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceName;
    private final String instanceHealth;
    private final String instanceHealthReason;

    private InstanceHealthSummary(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.instanceHealth = builder.instanceHealth;
        this.instanceHealthReason = builder.instanceHealthReason;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final InstanceHealthState instanceHealth() {
        return InstanceHealthState.fromValue(this.instanceHealth);
    }

    public final String instanceHealthAsString() {
        return this.instanceHealth;
    }

    public final InstanceHealthReason instanceHealthReason() {
        return InstanceHealthReason.fromValue(this.instanceHealthReason);
    }

    public final String instanceHealthReasonAsString() {
        return this.instanceHealthReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHealthSummary)) {
            return false;
        }
        InstanceHealthSummary other = (InstanceHealthSummary)obj;
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.instanceHealthAsString(), other.instanceHealthAsString()) && Objects.equals(this.instanceHealthReasonAsString(), other.instanceHealthReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceHealthSummary").add("InstanceName", (Object)this.instanceName()).add("InstanceHealth", (Object)this.instanceHealthAsString()).add("InstanceHealthReason", (Object)this.instanceHealthReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "instanceHealth": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthAsString()));
            }
            case "instanceHealthReason": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceHealthSummary, T> g) {
        return obj -> g.apply((InstanceHealthSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String instanceHealth;
        private String instanceHealthReason;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHealthSummary model) {
            this.instanceName(model.instanceName);
            this.instanceHealth(model.instanceHealth);
            this.instanceHealthReason(model.instanceHealthReason);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        @Transient
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getInstanceHealth() {
            return this.instanceHealth;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        @Override
        @Transient
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceHealth(InstanceHealthState instanceHealth) {
            this.instanceHealth(instanceHealth == null ? null : instanceHealth.toString());
            return this;
        }

        public final String getInstanceHealthReason() {
            return this.instanceHealthReason;
        }

        public final void setInstanceHealthReason(String instanceHealthReason) {
            this.instanceHealthReason = instanceHealthReason;
        }

        @Override
        @Transient
        public final Builder instanceHealthReason(String instanceHealthReason) {
            this.instanceHealthReason = instanceHealthReason;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceHealthReason(InstanceHealthReason instanceHealthReason) {
            this.instanceHealthReason(instanceHealthReason == null ? null : instanceHealthReason.toString());
            return this;
        }

        public InstanceHealthSummary build() {
            return new InstanceHealthSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceHealthSummary> {
        public Builder instanceName(String var1);

        public Builder instanceHealth(String var1);

        public Builder instanceHealth(InstanceHealthState var1);

        public Builder instanceHealthReason(String var1);

        public Builder instanceHealthReason(InstanceHealthReason var1);
    }
}

