/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.ContactProtocol;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContactMethodRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateContactMethodRequest> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(CreateContactMethodRequest.getter(CreateContactMethodRequest::protocolAsString)).setter(CreateContactMethodRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> CONTACT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactEndpoint").getter(CreateContactMethodRequest.getter(CreateContactMethodRequest::contactEndpoint)).setter(CreateContactMethodRequest.setter(Builder::contactEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, CONTACT_ENDPOINT_FIELD));
    private final String protocol;
    private final String contactEndpoint;

    private CreateContactMethodRequest(BuilderImpl builder) {
        super(builder);
        this.protocol = builder.protocol;
        this.contactEndpoint = builder.contactEndpoint;
    }

    public final ContactProtocol protocol() {
        return ContactProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String contactEndpoint() {
        return this.contactEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactMethodRequest)) {
            return false;
        }
        CreateContactMethodRequest other = (CreateContactMethodRequest)((Object)obj);
        return Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.contactEndpoint(), other.contactEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContactMethodRequest").add("Protocol", (Object)this.protocolAsString()).add("ContactEndpoint", (Object)this.contactEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "contactEndpoint": {
                return Optional.ofNullable(clazz.cast(this.contactEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactMethodRequest, T> g) {
        return obj -> g.apply((CreateContactMethodRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String protocol;
        private String contactEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactMethodRequest model) {
            super(model);
            this.protocol(model.protocol);
            this.contactEndpoint(model.contactEndpoint);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(ContactProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getContactEndpoint() {
            return this.contactEndpoint;
        }

        public final void setContactEndpoint(String contactEndpoint) {
            this.contactEndpoint = contactEndpoint;
        }

        @Override
        @Transient
        public final Builder contactEndpoint(String contactEndpoint) {
            this.contactEndpoint = contactEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactMethodRequest build() {
            return new CreateContactMethodRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContactMethodRequest> {
        public Builder protocol(String var1);

        public Builder protocol(ContactProtocol var1);

        public Builder contactEndpoint(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

