/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloseInstancePublicPortsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CloseInstancePublicPortsRequest> {
    private static final SdkField<PortInfo> PORT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portInfo").getter(CloseInstancePublicPortsRequest.getter(CloseInstancePublicPortsRequest::portInfo)).setter(CloseInstancePublicPortsRequest.setter(Builder::portInfo)).constructor(PortInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInfo").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(CloseInstancePublicPortsRequest.getter(CloseInstancePublicPortsRequest::instanceName)).setter(CloseInstancePublicPortsRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_INFO_FIELD, INSTANCE_NAME_FIELD));
    private final PortInfo portInfo;
    private final String instanceName;

    private CloseInstancePublicPortsRequest(BuilderImpl builder) {
        super(builder);
        this.portInfo = builder.portInfo;
        this.instanceName = builder.instanceName;
    }

    public final PortInfo portInfo() {
        return this.portInfo;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloseInstancePublicPortsRequest)) {
            return false;
        }
        CloseInstancePublicPortsRequest other = (CloseInstancePublicPortsRequest)((Object)obj);
        return Objects.equals(this.portInfo(), other.portInfo()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public final String toString() {
        return ToString.builder((String)"CloseInstancePublicPortsRequest").add("PortInfo", (Object)this.portInfo()).add("InstanceName", (Object)this.instanceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portInfo": {
                return Optional.ofNullable(clazz.cast(this.portInfo()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloseInstancePublicPortsRequest, T> g) {
        return obj -> g.apply((CloseInstancePublicPortsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private PortInfo portInfo;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloseInstancePublicPortsRequest model) {
            super(model);
            this.portInfo(model.portInfo);
            this.instanceName(model.instanceName);
        }

        public final PortInfo.Builder getPortInfo() {
            return this.portInfo != null ? this.portInfo.toBuilder() : null;
        }

        public final void setPortInfo(PortInfo.BuilderImpl portInfo) {
            this.portInfo = portInfo != null ? portInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder portInfo(PortInfo portInfo) {
            this.portInfo = portInfo;
            return this;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        @Transient
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CloseInstancePublicPortsRequest build() {
            return new CloseInstancePublicPortsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CloseInstancePublicPortsRequest> {
        public Builder portInfo(PortInfo var1);

        default public Builder portInfo(Consumer<PortInfo.Builder> portInfo) {
            return this.portInfo((PortInfo)((PortInfo.Builder)PortInfo.builder().applyMutation(portInfo)).build());
        }

        public Builder instanceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

