/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePublicDomainsCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContainerServiceRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateContainerServiceRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(UpdateContainerServiceRequest.getter(UpdateContainerServiceRequest::serviceName)).setter(UpdateContainerServiceRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> POWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("power").getter(UpdateContainerServiceRequest.getter(UpdateContainerServiceRequest::powerAsString)).setter(UpdateContainerServiceRequest.setter(Builder::power)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("power").build()}).build();
    private static final SdkField<Integer> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scale").getter(UpdateContainerServiceRequest.getter(UpdateContainerServiceRequest::scale)).setter(UpdateContainerServiceRequest.setter(Builder::scale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()}).build();
    private static final SdkField<Boolean> IS_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDisabled").getter(UpdateContainerServiceRequest.getter(UpdateContainerServiceRequest::isDisabled)).setter(UpdateContainerServiceRequest.setter(Builder::isDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDisabled").build()}).build();
    private static final SdkField<Map<String, List<String>>> PUBLIC_DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("publicDomainNames").getter(UpdateContainerServiceRequest.getter(UpdateContainerServiceRequest::publicDomainNames)).setter(UpdateContainerServiceRequest.setter(Builder::publicDomainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDomainNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, POWER_FIELD, SCALE_FIELD, IS_DISABLED_FIELD, PUBLIC_DOMAIN_NAMES_FIELD));
    private final String serviceName;
    private final String power;
    private final Integer scale;
    private final Boolean isDisabled;
    private final Map<String, List<String>> publicDomainNames;

    private UpdateContainerServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.power = builder.power;
        this.scale = builder.scale;
        this.isDisabled = builder.isDisabled;
        this.publicDomainNames = builder.publicDomainNames;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final ContainerServicePowerName power() {
        return ContainerServicePowerName.fromValue(this.power);
    }

    public final String powerAsString() {
        return this.power;
    }

    public final Integer scale() {
        return this.scale;
    }

    public final Boolean isDisabled() {
        return this.isDisabled;
    }

    public final boolean hasPublicDomainNames() {
        return this.publicDomainNames != null && !(this.publicDomainNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> publicDomainNames() {
        return this.publicDomainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicDomainNames() ? this.publicDomainNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerServiceRequest)) {
            return false;
        }
        UpdateContainerServiceRequest other = (UpdateContainerServiceRequest)((Object)obj);
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.powerAsString(), other.powerAsString()) && Objects.equals(this.scale(), other.scale()) && Objects.equals(this.isDisabled(), other.isDisabled()) && this.hasPublicDomainNames() == other.hasPublicDomainNames() && Objects.equals(this.publicDomainNames(), other.publicDomainNames());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContainerServiceRequest").add("ServiceName", (Object)this.serviceName()).add("Power", (Object)this.powerAsString()).add("Scale", (Object)this.scale()).add("IsDisabled", (Object)this.isDisabled()).add("PublicDomainNames", this.hasPublicDomainNames() ? this.publicDomainNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "power": {
                return Optional.ofNullable(clazz.cast(this.powerAsString()));
            }
            case "scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
            case "isDisabled": {
                return Optional.ofNullable(clazz.cast(this.isDisabled()));
            }
            case "publicDomainNames": {
                return Optional.ofNullable(clazz.cast(this.publicDomainNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerServiceRequest, T> g) {
        return obj -> g.apply((UpdateContainerServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String serviceName;
        private String power;
        private Integer scale;
        private Boolean isDisabled;
        private Map<String, List<String>> publicDomainNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerServiceRequest model) {
            super(model);
            this.serviceName(model.serviceName);
            this.power(model.power);
            this.scale(model.scale);
            this.isDisabled(model.isDisabled);
            this.publicDomainNames(model.publicDomainNames);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getPower() {
            return this.power;
        }

        @Override
        public final Builder power(String power) {
            this.power = power;
            return this;
        }

        @Override
        public final Builder power(ContainerServicePowerName power) {
            this.power(power == null ? null : power.toString());
            return this;
        }

        public final void setPower(String power) {
            this.power = power;
        }

        public final Integer getScale() {
            return this.scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final Boolean getIsDisabled() {
            return this.isDisabled;
        }

        @Override
        public final Builder isDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public final void setIsDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
        }

        public final Map<String, ? extends Collection<String>> getPublicDomainNames() {
            if (this.publicDomainNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.publicDomainNames;
        }

        @Override
        public final Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
            return this;
        }

        public final void setPublicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerServiceRequest build() {
            return new UpdateContainerServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContainerServiceRequest> {
        public Builder serviceName(String var1);

        public Builder power(String var1);

        public Builder power(ContainerServicePowerName var1);

        public Builder scale(Integer var1);

        public Builder isDisabled(Boolean var1);

        public Builder publicDomainNames(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

