/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.AccessType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessRules
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessRules> {
    private static final SdkField<String> GET_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("getObject").getter(AccessRules.getter(AccessRules::getObjectAsString)).setter(AccessRules.setter(Builder::getObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("getObject").build()}).build();
    private static final SdkField<Boolean> ALLOW_PUBLIC_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowPublicOverrides").getter(AccessRules.getter(AccessRules::allowPublicOverrides)).setter(AccessRules.setter(Builder::allowPublicOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowPublicOverrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GET_OBJECT_FIELD, ALLOW_PUBLIC_OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String getObject;
    private final Boolean allowPublicOverrides;

    private AccessRules(BuilderImpl builder) {
        this.getObject = builder.getObject;
        this.allowPublicOverrides = builder.allowPublicOverrides;
    }

    public final AccessType getObject() {
        return AccessType.fromValue(this.getObject);
    }

    public final String getObjectAsString() {
        return this.getObject;
    }

    public final Boolean allowPublicOverrides() {
        return this.allowPublicOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.getObjectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowPublicOverrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessRules)) {
            return false;
        }
        AccessRules other = (AccessRules)obj;
        return Objects.equals(this.getObjectAsString(), other.getObjectAsString()) && Objects.equals(this.allowPublicOverrides(), other.allowPublicOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"AccessRules").add("GetObject", (Object)this.getObjectAsString()).add("AllowPublicOverrides", (Object)this.allowPublicOverrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "getObject": {
                return Optional.ofNullable(clazz.cast(this.getObjectAsString()));
            }
            case "allowPublicOverrides": {
                return Optional.ofNullable(clazz.cast(this.allowPublicOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessRules, T> g) {
        return obj -> g.apply((AccessRules)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String getObject;
        private Boolean allowPublicOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessRules model) {
            this.getObject(model.getObject);
            this.allowPublicOverrides(model.allowPublicOverrides);
        }

        public final String getGetObject() {
            return this.getObject;
        }

        @Override
        public final Builder getObject(String getObject) {
            this.getObject = getObject;
            return this;
        }

        @Override
        public final Builder getObject(AccessType getObject) {
            this.getObject(getObject == null ? null : getObject.toString());
            return this;
        }

        public final void setGetObject(String getObject) {
            this.getObject = getObject;
        }

        public final Boolean getAllowPublicOverrides() {
            return this.allowPublicOverrides;
        }

        @Override
        public final Builder allowPublicOverrides(Boolean allowPublicOverrides) {
            this.allowPublicOverrides = allowPublicOverrides;
            return this;
        }

        public final void setAllowPublicOverrides(Boolean allowPublicOverrides) {
            this.allowPublicOverrides = allowPublicOverrides;
        }

        public AccessRules build() {
            return new AccessRules(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessRules> {
        public Builder getObject(String var1);

        public Builder getObject(AccessType var1);

        public Builder allowPublicOverrides(Boolean var1);
    }
}

