/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContainerService;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerServicesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContainerServicesResponse> {
    private static final SdkField<List<ContainerService>> CONTAINER_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerServices").getter(GetContainerServicesResponse.getter(GetContainerServicesResponse::containerServices)).setter(GetContainerServicesResponse.setter(Builder::containerServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SERVICES_FIELD));
    private final List<ContainerService> containerServices;

    private GetContainerServicesResponse(BuilderImpl builder) {
        super(builder);
        this.containerServices = builder.containerServices;
    }

    public final boolean hasContainerServices() {
        return this.containerServices != null && !(this.containerServices instanceof SdkAutoConstructList);
    }

    public final List<ContainerService> containerServices() {
        return this.containerServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerServices() ? this.containerServices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServicesResponse)) {
            return false;
        }
        GetContainerServicesResponse other = (GetContainerServicesResponse)((Object)obj);
        return this.hasContainerServices() == other.hasContainerServices() && Objects.equals(this.containerServices(), other.containerServices());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerServicesResponse").add("ContainerServices", this.hasContainerServices() ? this.containerServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerServices": {
                return Optional.ofNullable(clazz.cast(this.containerServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerServicesResponse, T> g) {
        return obj -> g.apply((GetContainerServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ContainerService> containerServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerServicesResponse model) {
            super(model);
            this.containerServices(model.containerServices);
        }

        public final List<ContainerService.Builder> getContainerServices() {
            List<ContainerService.Builder> result = ContainerServiceListCopier.copyToBuilder(this.containerServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerServices(Collection<ContainerService.BuilderImpl> containerServices) {
            this.containerServices = ContainerServiceListCopier.copyFromBuilder(containerServices);
        }

        @Override
        @Transient
        public final Builder containerServices(Collection<ContainerService> containerServices) {
            this.containerServices = ContainerServiceListCopier.copy(containerServices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containerServices(ContainerService ... containerServices) {
            this.containerServices(Arrays.asList(containerServices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containerServices(Consumer<ContainerService.Builder> ... containerServices) {
            this.containerServices(Stream.of(containerServices).map(c -> (ContainerService)((ContainerService.Builder)ContainerService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetContainerServicesResponse build() {
            return new GetContainerServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerServicesResponse> {
        public Builder containerServices(Collection<ContainerService> var1);

        public Builder containerServices(ContainerService ... var1);

        public Builder containerServices(Consumer<ContainerService.Builder> ... var1);
    }
}

