/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactProtocol {
    EMAIL("Email"),
    SMS("SMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactProtocol> VALUE_MAP;
    private final String value;

    private ContactProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactProtocol> knownValues() {
        EnumSet<ContactProtocol> knownValues = EnumSet.allOf(ContactProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactProtocol.class, ContactProtocol::toString);
    }
}

