/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CacheBehavior;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorListCopier;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath;
import software.amazon.awssdk.services.lightsail.model.CacheSettings;
import software.amazon.awssdk.services.lightsail.model.IpAddressType;
import software.amazon.awssdk.services.lightsail.model.Origin;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LightsailDistribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LightsailDistribution> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LightsailDistribution.getter(LightsailDistribution::name)).setter(LightsailDistribution.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LightsailDistribution.getter(LightsailDistribution::arn)).setter(LightsailDistribution.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(LightsailDistribution.getter(LightsailDistribution::supportCode)).setter(LightsailDistribution.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(LightsailDistribution.getter(LightsailDistribution::createdAt)).setter(LightsailDistribution.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(LightsailDistribution.getter(LightsailDistribution::location)).setter(LightsailDistribution.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(LightsailDistribution.getter(LightsailDistribution::resourceTypeAsString)).setter(LightsailDistribution.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> ALTERNATIVE_DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alternativeDomainNames").getter(LightsailDistribution.getter(LightsailDistribution::alternativeDomainNames)).setter(LightsailDistribution.setter(Builder::alternativeDomainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternativeDomainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LightsailDistribution.getter(LightsailDistribution::status)).setter(LightsailDistribution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isEnabled").getter(LightsailDistribution.getter(LightsailDistribution::isEnabled)).setter(LightsailDistribution.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(LightsailDistribution.getter(LightsailDistribution::domainName)).setter(LightsailDistribution.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(LightsailDistribution.getter(LightsailDistribution::bundleId)).setter(LightsailDistribution.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateName").getter(LightsailDistribution.getter(LightsailDistribution::certificateName)).setter(LightsailDistribution.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<Origin> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("origin").getter(LightsailDistribution.getter(LightsailDistribution::origin)).setter(LightsailDistribution.setter(Builder::origin)).constructor(Origin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<String> ORIGIN_PUBLIC_DNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originPublicDNS").getter(LightsailDistribution.getter(LightsailDistribution::originPublicDNS)).setter(LightsailDistribution.setter(Builder::originPublicDNS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originPublicDNS").build()}).build();
    private static final SdkField<CacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultCacheBehavior").getter(LightsailDistribution.getter(LightsailDistribution::defaultCacheBehavior)).setter(LightsailDistribution.setter(Builder::defaultCacheBehavior)).constructor(CacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCacheBehavior").build()}).build();
    private static final SdkField<CacheSettings> CACHE_BEHAVIOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cacheBehaviorSettings").getter(LightsailDistribution.getter(LightsailDistribution::cacheBehaviorSettings)).setter(LightsailDistribution.setter(Builder::cacheBehaviorSettings)).constructor(CacheSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviorSettings").build()}).build();
    private static final SdkField<List<CacheBehaviorPerPath>> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheBehaviors").getter(LightsailDistribution.getter(LightsailDistribution::cacheBehaviors)).setter(LightsailDistribution.setter(Builder::cacheBehaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheBehaviorPerPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ABLE_TO_UPDATE_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ableToUpdateBundle").getter(LightsailDistribution.getter(LightsailDistribution::ableToUpdateBundle)).setter(LightsailDistribution.setter(Builder::ableToUpdateBundle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ableToUpdateBundle").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(LightsailDistribution.getter(LightsailDistribution::ipAddressTypeAsString)).setter(LightsailDistribution.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(LightsailDistribution.getter(LightsailDistribution::tags)).setter(LightsailDistribution.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, ALTERNATIVE_DOMAIN_NAMES_FIELD, STATUS_FIELD, IS_ENABLED_FIELD, DOMAIN_NAME_FIELD, BUNDLE_ID_FIELD, CERTIFICATE_NAME_FIELD, ORIGIN_FIELD, ORIGIN_PUBLIC_DNS_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIOR_SETTINGS_FIELD, CACHE_BEHAVIORS_FIELD, ABLE_TO_UPDATE_BUNDLE_FIELD, IP_ADDRESS_TYPE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<String> alternativeDomainNames;
    private final String status;
    private final Boolean isEnabled;
    private final String domainName;
    private final String bundleId;
    private final String certificateName;
    private final Origin origin;
    private final String originPublicDNS;
    private final CacheBehavior defaultCacheBehavior;
    private final CacheSettings cacheBehaviorSettings;
    private final List<CacheBehaviorPerPath> cacheBehaviors;
    private final Boolean ableToUpdateBundle;
    private final String ipAddressType;
    private final List<Tag> tags;

    private LightsailDistribution(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.alternativeDomainNames = builder.alternativeDomainNames;
        this.status = builder.status;
        this.isEnabled = builder.isEnabled;
        this.domainName = builder.domainName;
        this.bundleId = builder.bundleId;
        this.certificateName = builder.certificateName;
        this.origin = builder.origin;
        this.originPublicDNS = builder.originPublicDNS;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.ableToUpdateBundle = builder.ableToUpdateBundle;
        this.ipAddressType = builder.ipAddressType;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasAlternativeDomainNames() {
        return this.alternativeDomainNames != null && !(this.alternativeDomainNames instanceof SdkAutoConstructList);
    }

    public final List<String> alternativeDomainNames() {
        return this.alternativeDomainNames;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String certificateName() {
        return this.certificateName;
    }

    public final Origin origin() {
        return this.origin;
    }

    public final String originPublicDNS() {
        return this.originPublicDNS;
    }

    public final CacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public final CacheSettings cacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public final boolean hasCacheBehaviors() {
        return this.cacheBehaviors != null && !(this.cacheBehaviors instanceof SdkAutoConstructList);
    }

    public final List<CacheBehaviorPerPath> cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public final Boolean ableToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternativeDomainNames() ? this.alternativeDomainNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.originPublicDNS());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheBehaviors() ? this.cacheBehaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ableToUpdateBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LightsailDistribution)) {
            return false;
        }
        LightsailDistribution other = (LightsailDistribution)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasAlternativeDomainNames() == other.hasAlternativeDomainNames() && Objects.equals(this.alternativeDomainNames(), other.alternativeDomainNames()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.originPublicDNS(), other.originPublicDNS()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviorSettings(), other.cacheBehaviorSettings()) && this.hasCacheBehaviors() == other.hasCacheBehaviors() && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.ableToUpdateBundle(), other.ableToUpdateBundle()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LightsailDistribution").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("AlternativeDomainNames", this.hasAlternativeDomainNames() ? this.alternativeDomainNames() : null).add("Status", (Object)this.status()).add("IsEnabled", (Object)this.isEnabled()).add("DomainName", (Object)this.domainName()).add("BundleId", (Object)this.bundleId()).add("CertificateName", (Object)this.certificateName()).add("Origin", (Object)this.origin()).add("OriginPublicDNS", (Object)this.originPublicDNS()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviorSettings", (Object)this.cacheBehaviorSettings()).add("CacheBehaviors", this.hasCacheBehaviors() ? this.cacheBehaviors() : null).add("AbleToUpdateBundle", (Object)this.ableToUpdateBundle()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "alternativeDomainNames": {
                return Optional.ofNullable(clazz.cast(this.alternativeDomainNames()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "isEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "originPublicDNS": {
                return Optional.ofNullable(clazz.cast(this.originPublicDNS()));
            }
            case "defaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "cacheBehaviorSettings": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorSettings()));
            }
            case "cacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "ableToUpdateBundle": {
                return Optional.ofNullable(clazz.cast(this.ableToUpdateBundle()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LightsailDistribution, T> g) {
        return obj -> g.apply((LightsailDistribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<String> alternativeDomainNames = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Boolean isEnabled;
        private String domainName;
        private String bundleId;
        private String certificateName;
        private Origin origin;
        private String originPublicDNS;
        private CacheBehavior defaultCacheBehavior;
        private CacheSettings cacheBehaviorSettings;
        private List<CacheBehaviorPerPath> cacheBehaviors = DefaultSdkAutoConstructList.getInstance();
        private Boolean ableToUpdateBundle;
        private String ipAddressType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LightsailDistribution model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.alternativeDomainNames(model.alternativeDomainNames);
            this.status(model.status);
            this.isEnabled(model.isEnabled);
            this.domainName(model.domainName);
            this.bundleId(model.bundleId);
            this.certificateName(model.certificateName);
            this.origin(model.origin);
            this.originPublicDNS(model.originPublicDNS);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviorSettings(model.cacheBehaviorSettings);
            this.cacheBehaviors(model.cacheBehaviors);
            this.ableToUpdateBundle(model.ableToUpdateBundle);
            this.ipAddressType(model.ipAddressType);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        @Transient
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Collection<String> getAlternativeDomainNames() {
            if (this.alternativeDomainNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alternativeDomainNames;
        }

        public final void setAlternativeDomainNames(Collection<String> alternativeDomainNames) {
            this.alternativeDomainNames = StringListCopier.copy(alternativeDomainNames);
        }

        @Override
        @Transient
        public final Builder alternativeDomainNames(Collection<String> alternativeDomainNames) {
            this.alternativeDomainNames = StringListCopier.copy(alternativeDomainNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alternativeDomainNames(String ... alternativeDomainNames) {
            this.alternativeDomainNames(Arrays.asList(alternativeDomainNames));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        @Transient
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        @Transient
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        @Transient
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final Origin.Builder getOrigin() {
            return this.origin != null ? this.origin.toBuilder() : null;
        }

        public final void setOrigin(Origin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        @Override
        @Transient
        public final Builder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        public final String getOriginPublicDNS() {
            return this.originPublicDNS;
        }

        public final void setOriginPublicDNS(String originPublicDNS) {
            this.originPublicDNS = originPublicDNS;
        }

        @Override
        @Transient
        public final Builder originPublicDNS(String originPublicDNS) {
            this.originPublicDNS = originPublicDNS;
            return this;
        }

        public final CacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(CacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheSettings.Builder getCacheBehaviorSettings() {
            return this.cacheBehaviorSettings != null ? this.cacheBehaviorSettings.toBuilder() : null;
        }

        public final void setCacheBehaviorSettings(CacheSettings.BuilderImpl cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings != null ? cacheBehaviorSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        public final List<CacheBehaviorPerPath.Builder> getCacheBehaviors() {
            List<CacheBehaviorPerPath.Builder> result = CacheBehaviorListCopier.copyToBuilder(this.cacheBehaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheBehaviors(Collection<CacheBehaviorPerPath.BuilderImpl> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copyFromBuilder(cacheBehaviors);
        }

        @Override
        @Transient
        public final Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copy(cacheBehaviors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
            this.cacheBehaviors(Arrays.asList(cacheBehaviors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... cacheBehaviors) {
            this.cacheBehaviors(Stream.of(cacheBehaviors).map(c -> (CacheBehaviorPerPath)((CacheBehaviorPerPath.Builder)CacheBehaviorPerPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAbleToUpdateBundle() {
            return this.ableToUpdateBundle;
        }

        public final void setAbleToUpdateBundle(Boolean ableToUpdateBundle) {
            this.ableToUpdateBundle = ableToUpdateBundle;
        }

        @Override
        @Transient
        public final Builder ableToUpdateBundle(Boolean ableToUpdateBundle) {
            this.ableToUpdateBundle = ableToUpdateBundle;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        @Transient
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LightsailDistribution build() {
            return new LightsailDistribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LightsailDistribution> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder alternativeDomainNames(Collection<String> var1);

        public Builder alternativeDomainNames(String ... var1);

        public Builder status(String var1);

        public Builder isEnabled(Boolean var1);

        public Builder domainName(String var1);

        public Builder bundleId(String var1);

        public Builder certificateName(String var1);

        public Builder origin(Origin var1);

        default public Builder origin(Consumer<Origin.Builder> origin) {
            return this.origin((Origin)((Origin.Builder)Origin.builder().applyMutation(origin)).build());
        }

        public Builder originPublicDNS(String var1);

        public Builder defaultCacheBehavior(CacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<CacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((CacheBehavior)((CacheBehavior.Builder)CacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviorSettings(CacheSettings var1);

        default public Builder cacheBehaviorSettings(Consumer<CacheSettings.Builder> cacheBehaviorSettings) {
            return this.cacheBehaviorSettings((CacheSettings)((CacheSettings.Builder)CacheSettings.builder().applyMutation(cacheBehaviorSettings)).build());
        }

        public Builder cacheBehaviors(Collection<CacheBehaviorPerPath> var1);

        public Builder cacheBehaviors(CacheBehaviorPerPath ... var1);

        public Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... var1);

        public Builder ableToUpdateBundle(Boolean var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

