/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailDistribution;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDistributionResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateDistributionResponse> {
    private static final SdkField<LightsailDistribution> DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("distribution").getter(CreateDistributionResponse.getter(CreateDistributionResponse::distribution)).setter(CreateDistributionResponse.setter(Builder::distribution)).constructor(LightsailDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()}).build();
    private static final SdkField<Operation> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("operation").getter(CreateDistributionResponse.getter(CreateDistributionResponse::operation)).setter(CreateDistributionResponse.setter(Builder::operation)).constructor(Operation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_FIELD, OPERATION_FIELD));
    private final LightsailDistribution distribution;
    private final Operation operation;

    private CreateDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.distribution = builder.distribution;
        this.operation = builder.operation;
    }

    public final LightsailDistribution distribution() {
        return this.distribution;
    }

    public final Operation operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionResponse)) {
            return false;
        }
        CreateDistributionResponse other = (CreateDistributionResponse)((Object)obj);
        return Objects.equals(this.distribution(), other.distribution()) && Objects.equals(this.operation(), other.operation());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDistributionResponse").add("Distribution", (Object)this.distribution()).add("Operation", (Object)this.operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distribution": {
                return Optional.ofNullable(clazz.cast(this.distribution()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDistributionResponse, T> g) {
        return obj -> g.apply((CreateDistributionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private LightsailDistribution distribution;
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionResponse model) {
            super(model);
            this.distribution(model.distribution);
            this.operation(model.operation);
        }

        public final LightsailDistribution.Builder getDistribution() {
            return this.distribution != null ? this.distribution.toBuilder() : null;
        }

        @Override
        public final Builder distribution(LightsailDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(LightsailDistribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        public final Operation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public CreateDistributionResponse build() {
            return new CreateDistributionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDistributionResponse> {
        public Builder distribution(LightsailDistribution var1);

        default public Builder distribution(Consumer<LightsailDistribution.Builder> distribution) {
            return this.distribution((LightsailDistribution)((LightsailDistribution.Builder)LightsailDistribution.builder().applyMutation(distribution)).build());
        }

        public Builder operation(Operation var1);

        default public Builder operation(Consumer<Operation.Builder> operation) {
            return this.operation((Operation)((Operation.Builder)Operation.builder().applyMutation(operation)).build());
        }
    }
}

