/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DistributionListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailDistribution;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDistributionsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetDistributionsResponse> {
    private static final SdkField<List<LightsailDistribution>> DISTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("distributions").getter(GetDistributionsResponse.getter(GetDistributionsResponse::distributions)).setter(GetDistributionsResponse.setter(Builder::distributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LightsailDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetDistributionsResponse.getter(GetDistributionsResponse::nextPageToken)).setter(GetDistributionsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTIONS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<LightsailDistribution> distributions;
    private final String nextPageToken;

    private GetDistributionsResponse(BuilderImpl builder) {
        super(builder);
        this.distributions = builder.distributions;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasDistributions() {
        return this.distributions != null && !(this.distributions instanceof SdkAutoConstructList);
    }

    public final List<LightsailDistribution> distributions() {
        return this.distributions;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistributions() ? this.distributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionsResponse)) {
            return false;
        }
        GetDistributionsResponse other = (GetDistributionsResponse)((Object)obj);
        return this.hasDistributions() == other.hasDistributions() && Objects.equals(this.distributions(), other.distributions()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDistributionsResponse").add("Distributions", this.hasDistributions() ? this.distributions() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distributions": {
                return Optional.ofNullable(clazz.cast(this.distributions()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionsResponse, T> g) {
        return obj -> g.apply((GetDistributionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<LightsailDistribution> distributions = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionsResponse model) {
            super(model);
            this.distributions(model.distributions);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<LightsailDistribution.Builder> getDistributions() {
            List<LightsailDistribution.Builder> result = DistributionListCopier.copyToBuilder(this.distributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder distributions(Collection<LightsailDistribution> distributions) {
            this.distributions = DistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(LightsailDistribution ... distributions) {
            this.distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<LightsailDistribution.Builder> ... distributions) {
            this.distributions(Stream.of(distributions).map(c -> (LightsailDistribution)((LightsailDistribution.Builder)LightsailDistribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDistributions(Collection<LightsailDistribution.BuilderImpl> distributions) {
            this.distributions = DistributionListCopier.copyFromBuilder(distributions);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDistributionsResponse build() {
            return new GetDistributionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDistributionsResponse> {
        public Builder distributions(Collection<LightsailDistribution> var1);

        public Builder distributions(LightsailDistribution ... var1);

        public Builder distributions(Consumer<LightsailDistribution.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

