/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CacheBehavior;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorListCopier;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath;
import software.amazon.awssdk.services.lightsail.model.CacheSettings;
import software.amazon.awssdk.services.lightsail.model.InputOrigin;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDistributionRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateDistributionRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionName").getter(UpdateDistributionRequest.getter(UpdateDistributionRequest::distributionName)).setter(UpdateDistributionRequest.setter(Builder::distributionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()}).build();
    private static final SdkField<InputOrigin> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("origin").getter(UpdateDistributionRequest.getter(UpdateDistributionRequest::origin)).setter(UpdateDistributionRequest.setter(Builder::origin)).constructor(InputOrigin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<CacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultCacheBehavior").getter(UpdateDistributionRequest.getter(UpdateDistributionRequest::defaultCacheBehavior)).setter(UpdateDistributionRequest.setter(Builder::defaultCacheBehavior)).constructor(CacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCacheBehavior").build()}).build();
    private static final SdkField<CacheSettings> CACHE_BEHAVIOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cacheBehaviorSettings").getter(UpdateDistributionRequest.getter(UpdateDistributionRequest::cacheBehaviorSettings)).setter(UpdateDistributionRequest.setter(Builder::cacheBehaviorSettings)).constructor(CacheSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviorSettings").build()}).build();
    private static final SdkField<List<CacheBehaviorPerPath>> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheBehaviors").getter(UpdateDistributionRequest.getter(UpdateDistributionRequest::cacheBehaviors)).setter(UpdateDistributionRequest.setter(Builder::cacheBehaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheBehaviorPerPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isEnabled").getter(UpdateDistributionRequest.getter(UpdateDistributionRequest::isEnabled)).setter(UpdateDistributionRequest.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD, ORIGIN_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIOR_SETTINGS_FIELD, CACHE_BEHAVIORS_FIELD, IS_ENABLED_FIELD));
    private final String distributionName;
    private final InputOrigin origin;
    private final CacheBehavior defaultCacheBehavior;
    private final CacheSettings cacheBehaviorSettings;
    private final List<CacheBehaviorPerPath> cacheBehaviors;
    private final Boolean isEnabled;

    private UpdateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.origin = builder.origin;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.isEnabled = builder.isEnabled;
    }

    public final String distributionName() {
        return this.distributionName;
    }

    public final InputOrigin origin() {
        return this.origin;
    }

    public final CacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public final CacheSettings cacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public final boolean hasCacheBehaviors() {
        return this.cacheBehaviors != null && !(this.cacheBehaviors instanceof SdkAutoConstructList);
    }

    public final List<CacheBehaviorPerPath> cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheBehaviors() ? this.cacheBehaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionRequest)) {
            return false;
        }
        UpdateDistributionRequest other = (UpdateDistributionRequest)((Object)obj);
        return Objects.equals(this.distributionName(), other.distributionName()) && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviorSettings(), other.cacheBehaviorSettings()) && this.hasCacheBehaviors() == other.hasCacheBehaviors() && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.isEnabled(), other.isEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDistributionRequest").add("DistributionName", (Object)this.distributionName()).add("Origin", (Object)this.origin()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviorSettings", (Object)this.cacheBehaviorSettings()).add("CacheBehaviors", this.hasCacheBehaviors() ? this.cacheBehaviors() : null).add("IsEnabled", (Object)this.isEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distributionName": {
                return Optional.ofNullable(clazz.cast(this.distributionName()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "defaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "cacheBehaviorSettings": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorSettings()));
            }
            case "cacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "isEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionRequest, T> g) {
        return obj -> g.apply((UpdateDistributionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String distributionName;
        private InputOrigin origin;
        private CacheBehavior defaultCacheBehavior;
        private CacheSettings cacheBehaviorSettings;
        private List<CacheBehaviorPerPath> cacheBehaviors = DefaultSdkAutoConstructList.getInstance();
        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionRequest model) {
            super(model);
            this.distributionName(model.distributionName);
            this.origin(model.origin);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviorSettings(model.cacheBehaviorSettings);
            this.cacheBehaviors(model.cacheBehaviors);
            this.isEnabled(model.isEnabled);
        }

        public final String getDistributionName() {
            return this.distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        public final InputOrigin.Builder getOrigin() {
            return this.origin != null ? this.origin.toBuilder() : null;
        }

        @Override
        public final Builder origin(InputOrigin origin) {
            this.origin = origin;
            return this;
        }

        public final void setOrigin(InputOrigin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        public final CacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(CacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheSettings.Builder getCacheBehaviorSettings() {
            return this.cacheBehaviorSettings != null ? this.cacheBehaviorSettings.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        public final void setCacheBehaviorSettings(CacheSettings.BuilderImpl cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings != null ? cacheBehaviorSettings.build() : null;
        }

        public final List<CacheBehaviorPerPath.Builder> getCacheBehaviors() {
            List<CacheBehaviorPerPath.Builder> result = CacheBehaviorListCopier.copyToBuilder(this.cacheBehaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copy(cacheBehaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
            this.cacheBehaviors(Arrays.asList(cacheBehaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... cacheBehaviors) {
            this.cacheBehaviors(Stream.of(cacheBehaviors).map(c -> (CacheBehaviorPerPath)((CacheBehaviorPerPath.Builder)CacheBehaviorPerPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheBehaviors(Collection<CacheBehaviorPerPath.BuilderImpl> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copyFromBuilder(cacheBehaviors);
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionRequest build() {
            return new UpdateDistributionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDistributionRequest> {
        public Builder distributionName(String var1);

        public Builder origin(InputOrigin var1);

        default public Builder origin(Consumer<InputOrigin.Builder> origin) {
            return this.origin((InputOrigin)((InputOrigin.Builder)InputOrigin.builder().applyMutation(origin)).build());
        }

        public Builder defaultCacheBehavior(CacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<CacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((CacheBehavior)((CacheBehavior.Builder)CacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviorSettings(CacheSettings var1);

        default public Builder cacheBehaviorSettings(Consumer<CacheSettings.Builder> cacheBehaviorSettings) {
            return this.cacheBehaviorSettings((CacheSettings)((CacheSettings.Builder)CacheSettings.builder().applyMutation(cacheBehaviorSettings)).build());
        }

        public Builder cacheBehaviors(Collection<CacheBehaviorPerPath> var1);

        public Builder cacheBehaviors(CacheBehaviorPerPath ... var1);

        public Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... var1);

        public Builder isEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

