/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AvailabilityZone;
import software.amazon.awssdk.services.lightsail.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Region
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Region> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continentCode").getter(Region.getter(Region::continentCode)).setter(Region.setter(Builder::continentCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continentCode").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Region.getter(Region::description)).setter(Region.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(Region.getter(Region::displayName)).setter(Region.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Region.getter(Region::nameAsString)).setter(Region.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availabilityZones").getter(Region.getter(Region::availabilityZones)).setter(Region.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AvailabilityZone>> RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationalDatabaseAvailabilityZones").getter(Region.getter(Region::relationalDatabaseAvailabilityZones)).setter(Region.setter(Builder::relationalDatabaseAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseAvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, NAME_FIELD, AVAILABILITY_ZONES_FIELD, RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String continentCode;
    private final String description;
    private final String displayName;
    private final String name;
    private final List<AvailabilityZone> availabilityZones;
    private final List<AvailabilityZone> relationalDatabaseAvailabilityZones;

    private Region(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.name = builder.name;
        this.availabilityZones = builder.availabilityZones;
        this.relationalDatabaseAvailabilityZones = builder.relationalDatabaseAvailabilityZones;
    }

    public final String continentCode() {
        return this.continentCode;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final RegionName name() {
        return RegionName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasRelationalDatabaseAvailabilityZones() {
        return this.relationalDatabaseAvailabilityZones != null && !(this.relationalDatabaseAvailabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZone> relationalDatabaseAvailabilityZones() {
        return this.relationalDatabaseAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationalDatabaseAvailabilityZones() ? this.relationalDatabaseAvailabilityZones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        return Objects.equals(this.continentCode(), other.continentCode()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.nameAsString(), other.nameAsString()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasRelationalDatabaseAvailabilityZones() == other.hasRelationalDatabaseAvailabilityZones() && Objects.equals(this.relationalDatabaseAvailabilityZones(), other.relationalDatabaseAvailabilityZones());
    }

    public final String toString() {
        return ToString.builder((String)"Region").add("ContinentCode", (Object)this.continentCode()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("Name", (Object)this.nameAsString()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("RelationalDatabaseAvailabilityZones", this.hasRelationalDatabaseAvailabilityZones() ? this.relationalDatabaseAvailabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "continentCode": {
                return Optional.ofNullable(clazz.cast(this.continentCode()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "availabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "relationalDatabaseAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String continentCode;
        private String description;
        private String displayName;
        private String name;
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<AvailabilityZone> relationalDatabaseAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            this.continentCode(model.continentCode);
            this.description(model.description);
            this.displayName(model.displayName);
            this.name(model.name);
            this.availabilityZones(model.availabilityZones);
            this.relationalDatabaseAvailabilityZones(model.relationalDatabaseAvailabilityZones);
        }

        public final String getContinentCode() {
            return this.continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RegionName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones != null ? (Collection)this.availabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        public final Collection<AvailabilityZone.Builder> getRelationalDatabaseAvailabilityZones() {
            if (this.relationalDatabaseAvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relationalDatabaseAvailabilityZones != null ? (Collection)this.relationalDatabaseAvailabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relationalDatabaseAvailabilityZones(Collection<AvailabilityZone> relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones = AvailabilityZoneListCopier.copy(relationalDatabaseAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseAvailabilityZones(AvailabilityZone ... relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones(Arrays.asList(relationalDatabaseAvailabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseAvailabilityZones(Consumer<AvailabilityZone.Builder> ... relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones(Stream.of(relationalDatabaseAvailabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelationalDatabaseAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones = AvailabilityZoneListCopier.copyFromBuilder(relationalDatabaseAvailabilityZones);
        }

        public Region build() {
            return new Region(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Region> {
        public Builder continentCode(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder name(String var1);

        public Builder name(RegionName var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder relationalDatabaseAvailabilityZones(Collection<AvailabilityZone> var1);

        public Builder relationalDatabaseAvailabilityZones(AvailabilityZone ... var1);

        public Builder relationalDatabaseAvailabilityZones(Consumer<AvailabilityZone.Builder> ... var1);
    }
}

