/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AccessReceiverListCopier;
import software.amazon.awssdk.services.lightsail.model.AccessRules;
import software.amazon.awssdk.services.lightsail.model.BucketState;
import software.amazon.awssdk.services.lightsail.model.PartnerIdListCopier;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Bucket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Bucket> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(Bucket.getter(Bucket::resourceType)).setter(Bucket.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<AccessRules> ACCESS_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessRules").getter(Bucket.getter(Bucket::accessRules)).setter(Bucket.setter(Builder::accessRules)).constructor(AccessRules::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRules").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Bucket.getter(Bucket::arn)).setter(Bucket.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(Bucket.getter(Bucket::bundleId)).setter(Bucket.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Bucket.getter(Bucket::createdAt)).setter(Bucket.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(Bucket.getter(Bucket::url)).setter(Bucket.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Bucket.getter(Bucket::location)).setter(Bucket.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Bucket.getter(Bucket::name)).setter(Bucket.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(Bucket.getter(Bucket::supportCode)).setter(Bucket.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Bucket.getter(Bucket::tags)).setter(Bucket.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OBJECT_VERSIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectVersioning").getter(Bucket.getter(Bucket::objectVersioning)).setter(Bucket.setter(Builder::objectVersioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectVersioning").build()}).build();
    private static final SdkField<Boolean> ABLE_TO_UPDATE_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ableToUpdateBundle").getter(Bucket.getter(Bucket::ableToUpdateBundle)).setter(Bucket.setter(Builder::ableToUpdateBundle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ableToUpdateBundle").build()}).build();
    private static final SdkField<List<String>> READONLY_ACCESS_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("readonlyAccessAccounts").getter(Bucket.getter(Bucket::readonlyAccessAccounts)).setter(Bucket.setter(Builder::readonlyAccessAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyAccessAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceReceivingAccess>> RESOURCES_RECEIVING_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcesReceivingAccess").getter(Bucket.getter(Bucket::resourcesReceivingAccess)).setter(Bucket.setter(Builder::resourcesReceivingAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesReceivingAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceReceivingAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BucketState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(Bucket.getter(Bucket::state)).setter(Bucket.setter(Builder::state)).constructor(BucketState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, ACCESS_RULES_FIELD, ARN_FIELD, BUNDLE_ID_FIELD, CREATED_AT_FIELD, URL_FIELD, LOCATION_FIELD, NAME_FIELD, SUPPORT_CODE_FIELD, TAGS_FIELD, OBJECT_VERSIONING_FIELD, ABLE_TO_UPDATE_BUNDLE_FIELD, READONLY_ACCESS_ACCOUNTS_FIELD, RESOURCES_RECEIVING_ACCESS_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final AccessRules accessRules;
    private final String arn;
    private final String bundleId;
    private final Instant createdAt;
    private final String url;
    private final ResourceLocation location;
    private final String name;
    private final String supportCode;
    private final List<Tag> tags;
    private final String objectVersioning;
    private final Boolean ableToUpdateBundle;
    private final List<String> readonlyAccessAccounts;
    private final List<ResourceReceivingAccess> resourcesReceivingAccess;
    private final BucketState state;

    private Bucket(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.accessRules = builder.accessRules;
        this.arn = builder.arn;
        this.bundleId = builder.bundleId;
        this.createdAt = builder.createdAt;
        this.url = builder.url;
        this.location = builder.location;
        this.name = builder.name;
        this.supportCode = builder.supportCode;
        this.tags = builder.tags;
        this.objectVersioning = builder.objectVersioning;
        this.ableToUpdateBundle = builder.ableToUpdateBundle;
        this.readonlyAccessAccounts = builder.readonlyAccessAccounts;
        this.resourcesReceivingAccess = builder.resourcesReceivingAccess;
        this.state = builder.state;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final AccessRules accessRules() {
        return this.accessRules;
    }

    public final String arn() {
        return this.arn;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String url() {
        return this.url;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final String name() {
        return this.name;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String objectVersioning() {
        return this.objectVersioning;
    }

    public final Boolean ableToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public final boolean hasReadonlyAccessAccounts() {
        return this.readonlyAccessAccounts != null && !(this.readonlyAccessAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> readonlyAccessAccounts() {
        return this.readonlyAccessAccounts;
    }

    public final boolean hasResourcesReceivingAccess() {
        return this.resourcesReceivingAccess != null && !(this.resourcesReceivingAccess instanceof SdkAutoConstructList);
    }

    public final List<ResourceReceivingAccess> resourcesReceivingAccess() {
        return this.resourcesReceivingAccess;
    }

    public final BucketState state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.objectVersioning());
        hashCode = 31 * hashCode + Objects.hashCode(this.ableToUpdateBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadonlyAccessAccounts() ? this.readonlyAccessAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesReceivingAccess() ? this.resourcesReceivingAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.accessRules(), other.accessRules()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.supportCode(), other.supportCode()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.objectVersioning(), other.objectVersioning()) && Objects.equals(this.ableToUpdateBundle(), other.ableToUpdateBundle()) && this.hasReadonlyAccessAccounts() == other.hasReadonlyAccessAccounts() && Objects.equals(this.readonlyAccessAccounts(), other.readonlyAccessAccounts()) && this.hasResourcesReceivingAccess() == other.hasResourcesReceivingAccess() && Objects.equals(this.resourcesReceivingAccess(), other.resourcesReceivingAccess()) && Objects.equals(this.state(), other.state());
    }

    public final String toString() {
        return ToString.builder((String)"Bucket").add("ResourceType", (Object)this.resourceType()).add("AccessRules", (Object)this.accessRules()).add("Arn", (Object)this.arn()).add("BundleId", (Object)this.bundleId()).add("CreatedAt", (Object)this.createdAt()).add("Url", (Object)this.url()).add("Location", (Object)this.location()).add("Name", (Object)this.name()).add("SupportCode", (Object)this.supportCode()).add("Tags", this.hasTags() ? this.tags() : null).add("ObjectVersioning", (Object)this.objectVersioning()).add("AbleToUpdateBundle", (Object)this.ableToUpdateBundle()).add("ReadonlyAccessAccounts", this.hasReadonlyAccessAccounts() ? this.readonlyAccessAccounts() : null).add("ResourcesReceivingAccess", this.hasResourcesReceivingAccess() ? this.resourcesReceivingAccess() : null).add("State", (Object)this.state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "accessRules": {
                return Optional.ofNullable(clazz.cast(this.accessRules()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "objectVersioning": {
                return Optional.ofNullable(clazz.cast(this.objectVersioning()));
            }
            case "ableToUpdateBundle": {
                return Optional.ofNullable(clazz.cast(this.ableToUpdateBundle()));
            }
            case "readonlyAccessAccounts": {
                return Optional.ofNullable(clazz.cast(this.readonlyAccessAccounts()));
            }
            case "resourcesReceivingAccess": {
                return Optional.ofNullable(clazz.cast(this.resourcesReceivingAccess()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bucket, T> g) {
        return obj -> g.apply((Bucket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private AccessRules accessRules;
        private String arn;
        private String bundleId;
        private Instant createdAt;
        private String url;
        private ResourceLocation location;
        private String name;
        private String supportCode;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String objectVersioning;
        private Boolean ableToUpdateBundle;
        private List<String> readonlyAccessAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceReceivingAccess> resourcesReceivingAccess = DefaultSdkAutoConstructList.getInstance();
        private BucketState state;

        private BuilderImpl() {
        }

        private BuilderImpl(Bucket model) {
            this.resourceType(model.resourceType);
            this.accessRules(model.accessRules);
            this.arn(model.arn);
            this.bundleId(model.bundleId);
            this.createdAt(model.createdAt);
            this.url(model.url);
            this.location(model.location);
            this.name(model.name);
            this.supportCode(model.supportCode);
            this.tags(model.tags);
            this.objectVersioning(model.objectVersioning);
            this.ableToUpdateBundle(model.ableToUpdateBundle);
            this.readonlyAccessAccounts(model.readonlyAccessAccounts);
            this.resourcesReceivingAccess(model.resourcesReceivingAccess);
            this.state(model.state);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final AccessRules.Builder getAccessRules() {
            return this.accessRules != null ? this.accessRules.toBuilder() : null;
        }

        @Override
        public final Builder accessRules(AccessRules accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        public final void setAccessRules(AccessRules.BuilderImpl accessRules) {
            this.accessRules = accessRules != null ? accessRules.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getObjectVersioning() {
            return this.objectVersioning;
        }

        @Override
        public final Builder objectVersioning(String objectVersioning) {
            this.objectVersioning = objectVersioning;
            return this;
        }

        public final void setObjectVersioning(String objectVersioning) {
            this.objectVersioning = objectVersioning;
        }

        public final Boolean getAbleToUpdateBundle() {
            return this.ableToUpdateBundle;
        }

        @Override
        public final Builder ableToUpdateBundle(Boolean ableToUpdateBundle) {
            this.ableToUpdateBundle = ableToUpdateBundle;
            return this;
        }

        public final void setAbleToUpdateBundle(Boolean ableToUpdateBundle) {
            this.ableToUpdateBundle = ableToUpdateBundle;
        }

        public final Collection<String> getReadonlyAccessAccounts() {
            if (this.readonlyAccessAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readonlyAccessAccounts;
        }

        @Override
        public final Builder readonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
            this.readonlyAccessAccounts = PartnerIdListCopier.copy(readonlyAccessAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readonlyAccessAccounts(String ... readonlyAccessAccounts) {
            this.readonlyAccessAccounts(Arrays.asList(readonlyAccessAccounts));
            return this;
        }

        public final void setReadonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
            this.readonlyAccessAccounts = PartnerIdListCopier.copy(readonlyAccessAccounts);
        }

        public final List<ResourceReceivingAccess.Builder> getResourcesReceivingAccess() {
            List<ResourceReceivingAccess.Builder> result = AccessReceiverListCopier.copyToBuilder(this.resourcesReceivingAccess);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resourcesReceivingAccess(Collection<ResourceReceivingAccess> resourcesReceivingAccess) {
            this.resourcesReceivingAccess = AccessReceiverListCopier.copy(resourcesReceivingAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesReceivingAccess(ResourceReceivingAccess ... resourcesReceivingAccess) {
            this.resourcesReceivingAccess(Arrays.asList(resourcesReceivingAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesReceivingAccess(Consumer<ResourceReceivingAccess.Builder> ... resourcesReceivingAccess) {
            this.resourcesReceivingAccess(Stream.of(resourcesReceivingAccess).map(c -> (ResourceReceivingAccess)((ResourceReceivingAccess.Builder)ResourceReceivingAccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourcesReceivingAccess(Collection<ResourceReceivingAccess.BuilderImpl> resourcesReceivingAccess) {
            this.resourcesReceivingAccess = AccessReceiverListCopier.copyFromBuilder(resourcesReceivingAccess);
        }

        public final BucketState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(BucketState state) {
            this.state = state;
            return this;
        }

        public final void setState(BucketState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public Bucket build() {
            return new Bucket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Bucket> {
        public Builder resourceType(String var1);

        public Builder accessRules(AccessRules var1);

        default public Builder accessRules(Consumer<AccessRules.Builder> accessRules) {
            return this.accessRules((AccessRules)((AccessRules.Builder)AccessRules.builder().applyMutation(accessRules)).build());
        }

        public Builder arn(String var1);

        public Builder bundleId(String var1);

        public Builder createdAt(Instant var1);

        public Builder url(String var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder name(String var1);

        public Builder supportCode(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder objectVersioning(String var1);

        public Builder ableToUpdateBundle(Boolean var1);

        public Builder readonlyAccessAccounts(Collection<String> var1);

        public Builder readonlyAccessAccounts(String ... var1);

        public Builder resourcesReceivingAccess(Collection<ResourceReceivingAccess> var1);

        public Builder resourcesReceivingAccess(ResourceReceivingAccess ... var1);

        public Builder resourcesReceivingAccess(Consumer<ResourceReceivingAccess.Builder> ... var1);

        public Builder state(BucketState var1);

        default public Builder state(Consumer<BucketState.Builder> state) {
            return this.state((BucketState)((BucketState.Builder)BucketState.builder().applyMutation(state)).build());
        }
    }
}

