/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerServicePower
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerServicePower> {
    private static final SdkField<String> POWER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("powerId").getter(ContainerServicePower.getter(ContainerServicePower::powerId)).setter(ContainerServicePower.setter(Builder::powerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("powerId").build()}).build();
    private static final SdkField<Float> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("price").getter(ContainerServicePower.getter(ContainerServicePower::price)).setter(ContainerServicePower.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()}).build();
    private static final SdkField<Float> CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("cpuCount").getter(ContainerServicePower.getter(ContainerServicePower::cpuCount)).setter(ContainerServicePower.setter(Builder::cpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()}).build();
    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("ramSizeInGb").getter(ContainerServicePower.getter(ContainerServicePower::ramSizeInGb)).setter(ContainerServicePower.setter(Builder::ramSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ContainerServicePower.getter(ContainerServicePower::name)).setter(ContainerServicePower.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(ContainerServicePower.getter(ContainerServicePower::isActive)).setter(ContainerServicePower.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POWER_ID_FIELD, PRICE_FIELD, CPU_COUNT_FIELD, RAM_SIZE_IN_GB_FIELD, NAME_FIELD, IS_ACTIVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String powerId;
    private final Float price;
    private final Float cpuCount;
    private final Float ramSizeInGb;
    private final String name;
    private final Boolean isActive;

    private ContainerServicePower(BuilderImpl builder) {
        this.powerId = builder.powerId;
        this.price = builder.price;
        this.cpuCount = builder.cpuCount;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.name = builder.name;
        this.isActive = builder.isActive;
    }

    public final String powerId() {
        return this.powerId;
    }

    public final Float price() {
        return this.price;
    }

    public final Float cpuCount() {
        return this.cpuCount;
    }

    public final Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.powerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServicePower)) {
            return false;
        }
        ContainerServicePower other = (ContainerServicePower)obj;
        return Objects.equals(this.powerId(), other.powerId()) && Objects.equals(this.price(), other.price()) && Objects.equals(this.cpuCount(), other.cpuCount()) && Objects.equals(this.ramSizeInGb(), other.ramSizeInGb()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.isActive(), other.isActive());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerServicePower").add("PowerId", (Object)this.powerId()).add("Price", (Object)this.price()).add("CpuCount", (Object)this.cpuCount()).add("RamSizeInGb", (Object)this.ramSizeInGb()).add("Name", (Object)this.name()).add("IsActive", (Object)this.isActive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "powerId": {
                return Optional.ofNullable(clazz.cast(this.powerId()));
            }
            case "price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "cpuCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCount()));
            }
            case "ramSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.ramSizeInGb()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServicePower, T> g) {
        return obj -> g.apply((ContainerServicePower)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String powerId;
        private Float price;
        private Float cpuCount;
        private Float ramSizeInGb;
        private String name;
        private Boolean isActive;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServicePower model) {
            this.powerId(model.powerId);
            this.price(model.price);
            this.cpuCount(model.cpuCount);
            this.ramSizeInGb(model.ramSizeInGb);
            this.name(model.name);
            this.isActive(model.isActive);
        }

        public final String getPowerId() {
            return this.powerId;
        }

        @Override
        public final Builder powerId(String powerId) {
            this.powerId = powerId;
            return this;
        }

        public final void setPowerId(String powerId) {
            this.powerId = powerId;
        }

        public final Float getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Float getCpuCount() {
            return this.cpuCount;
        }

        @Override
        public final Builder cpuCount(Float cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Float cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public ContainerServicePower build() {
            return new ContainerServicePower(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerServicePower> {
        public Builder powerId(String var1);

        public Builder price(Float var1);

        public Builder cpuCount(Float var1);

        public Builder ramSizeInGb(Float var1);

        public Builder name(String var1);

        public Builder isActive(Boolean var1);
    }
}

