/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContactProtocol;
import software.amazon.awssdk.services.lightsail.model.ContactProtocolsListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactMethodsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetContactMethodsRequest> {
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("protocols").getter(GetContactMethodsRequest.getter(GetContactMethodsRequest::protocolsAsStrings)).setter(GetContactMethodsRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOLS_FIELD));
    private final List<String> protocols;

    private GetContactMethodsRequest(BuilderImpl builder) {
        super(builder);
        this.protocols = builder.protocols;
    }

    public List<ContactProtocol> protocols() {
        return ContactProtocolsListCopier.copyStringToEnum(this.protocols);
    }

    public boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public List<String> protocolsAsStrings() {
        return this.protocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMethodsRequest)) {
            return false;
        }
        GetContactMethodsRequest other = (GetContactMethodsRequest)((Object)obj);
        return this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetContactMethodsRequest").add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactMethodsRequest, T> g) {
        return obj -> g.apply((GetContactMethodsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactMethodsRequest model) {
            super(model);
            this.protocolsWithStrings(model.protocols);
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ContactProtocolsListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<ContactProtocol> protocols) {
            this.protocols = ContactProtocolsListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(ContactProtocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ContactProtocolsListCopier.copy(protocols);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContactMethodsRequest build() {
            return new GetContactMethodsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactMethodsRequest> {
        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<ContactProtocol> var1);

        public Builder protocols(ContactProtocol ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

