/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceMetadataEntryListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerApiMetadataResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContainerApiMetadataResponse> {
    private static final SdkField<List<Map<String, String>>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadata").getter(GetContainerApiMetadataResponse.getter(GetContainerApiMetadataResponse::metadata)).setter(GetContainerApiMetadataResponse.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD));
    private final List<Map<String, String>> metadata;

    private GetContainerApiMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructList);
    }

    public List<Map<String, String>> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerApiMetadataResponse)) {
            return false;
        }
        GetContainerApiMetadataResponse other = (GetContainerApiMetadataResponse)((Object)obj);
        return this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata());
    }

    public String toString() {
        return ToString.builder((String)"GetContainerApiMetadataResponse").add("Metadata", this.hasMetadata() ? this.metadata() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerApiMetadataResponse, T> g) {
        return obj -> g.apply((GetContainerApiMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Map<String, String>> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerApiMetadataResponse model) {
            super(model);
            this.metadata(model.metadata);
        }

        public final Collection<? extends Map<String, String>> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metadata;
        }

        @Override
        public final Builder metadata(Collection<? extends Map<String, String>> metadata) {
            this.metadata = ContainerServiceMetadataEntryListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Map<String, String> ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<? extends Map<String, String>> metadata) {
            this.metadata = ContainerServiceMetadataEntryListCopier.copy(metadata);
        }

        @Override
        public GetContainerApiMetadataResponse build() {
            return new GetContainerApiMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerApiMetadataResponse> {
        public Builder metadata(Collection<? extends Map<String, String>> var1);

        public Builder metadata(Map<String, String> ... var1);
    }
}

