/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDistributionBundleRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateDistributionBundleRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionName").getter(UpdateDistributionBundleRequest.getter(UpdateDistributionBundleRequest::distributionName)).setter(UpdateDistributionBundleRequest.setter(Builder::distributionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(UpdateDistributionBundleRequest.getter(UpdateDistributionBundleRequest::bundleId)).setter(UpdateDistributionBundleRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD, BUNDLE_ID_FIELD));
    private final String distributionName;
    private final String bundleId;

    private UpdateDistributionBundleRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.bundleId = builder.bundleId;
    }

    public String distributionName() {
        return this.distributionName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionBundleRequest)) {
            return false;
        }
        UpdateDistributionBundleRequest other = (UpdateDistributionBundleRequest)((Object)obj);
        return Objects.equals(this.distributionName(), other.distributionName()) && Objects.equals(this.bundleId(), other.bundleId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDistributionBundleRequest").add("DistributionName", (Object)this.distributionName()).add("BundleId", (Object)this.bundleId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distributionName": {
                return Optional.ofNullable(clazz.cast(this.distributionName()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionBundleRequest, T> g) {
        return obj -> g.apply((UpdateDistributionBundleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String distributionName;
        private String bundleId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionBundleRequest model) {
            super(model);
            this.distributionName(model.distributionName);
            this.bundleId(model.bundleId);
        }

        public final String getDistributionName() {
            return this.distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionBundleRequest build() {
            return new UpdateDistributionBundleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDistributionBundleRequest> {
        public Builder distributionName(String var1);

        public Builder bundleId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

