/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticIp
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticIp> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StaticIp.getter(StaticIp::name)).setter(StaticIp.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(StaticIp.getter(StaticIp::arn)).setter(StaticIp.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(StaticIp.getter(StaticIp::supportCode)).setter(StaticIp.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StaticIp.getter(StaticIp::createdAt)).setter(StaticIp.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(StaticIp.getter(StaticIp::location)).setter(StaticIp.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(StaticIp.getter(StaticIp::resourceTypeAsString)).setter(StaticIp.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(StaticIp.getter(StaticIp::ipAddress)).setter(StaticIp.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> ATTACHED_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachedTo").getter(StaticIp.getter(StaticIp::attachedTo)).setter(StaticIp.setter(Builder::attachedTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedTo").build()}).build();
    private static final SdkField<Boolean> IS_ATTACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAttached").getter(StaticIp.getter(StaticIp::isAttached)).setter(StaticIp.setter(Builder::isAttached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAttached").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, IP_ADDRESS_FIELD, ATTACHED_TO_FIELD, IS_ATTACHED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String ipAddress;
    private final String attachedTo;
    private final Boolean isAttached;

    private StaticIp(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.ipAddress = builder.ipAddress;
        this.attachedTo = builder.attachedTo;
        this.isAttached = builder.isAttached;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String attachedTo() {
        return this.attachedTo;
    }

    public Boolean isAttached() {
        return this.isAttached;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttached());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticIp)) {
            return false;
        }
        StaticIp other = (StaticIp)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.attachedTo(), other.attachedTo()) && Objects.equals(this.isAttached(), other.isAttached());
    }

    public String toString() {
        return ToString.builder((String)"StaticIp").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("IpAddress", (Object)this.ipAddress()).add("AttachedTo", (Object)this.attachedTo()).add("IsAttached", (Object)this.isAttached()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "attachedTo": {
                return Optional.ofNullable(clazz.cast(this.attachedTo()));
            }
            case "isAttached": {
                return Optional.ofNullable(clazz.cast(this.isAttached()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticIp, T> g) {
        return obj -> g.apply((StaticIp)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String ipAddress;
        private String attachedTo;
        private Boolean isAttached;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticIp model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.ipAddress(model.ipAddress);
            this.attachedTo(model.attachedTo);
            this.isAttached(model.isAttached);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getAttachedTo() {
            return this.attachedTo;
        }

        @Override
        public final Builder attachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final void setAttachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
        }

        public final Boolean getIsAttached() {
            return this.isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        public StaticIp build() {
            return new StaticIp(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticIp> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder ipAddress(String var1);

        public Builder attachedTo(String var1);

        public Builder isAttached(Boolean var1);
    }
}

