/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRelationalDatabaseFromSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateRelationalDatabaseFromSnapshotRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseName").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::relationalDatabaseName)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::availabilityZone)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::publiclyAccessible)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<String> RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseSnapshotName").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::relationalDatabaseSnapshotName)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::relationalDatabaseSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSnapshotName").build()}).build();
    private static final SdkField<String> RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseBundleId").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::relationalDatabaseBundleId)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::relationalDatabaseBundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBundleId").build()}).build();
    private static final SdkField<String> SOURCE_RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRelationalDatabaseName").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::sourceRelationalDatabaseName)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::sourceRelationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRelationalDatabaseName").build()}).build();
    private static final SdkField<Instant> RESTORE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("restoreTime").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::restoreTime)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::restoreTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreTime").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useLatestRestorableTime").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::useLatestRestorableTime)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::useLatestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateRelationalDatabaseFromSnapshotRequest.getter(CreateRelationalDatabaseFromSnapshotRequest::tags)).setter(CreateRelationalDatabaseFromSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, AVAILABILITY_ZONE_FIELD, PUBLICLY_ACCESSIBLE_FIELD, RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD, RELATIONAL_DATABASE_BUNDLE_ID_FIELD, SOURCE_RELATIONAL_DATABASE_NAME_FIELD, RESTORE_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, TAGS_FIELD));
    private final String relationalDatabaseName;
    private final String availabilityZone;
    private final Boolean publiclyAccessible;
    private final String relationalDatabaseSnapshotName;
    private final String relationalDatabaseBundleId;
    private final String sourceRelationalDatabaseName;
    private final Instant restoreTime;
    private final Boolean useLatestRestorableTime;
    private final List<Tag> tags;

    private CreateRelationalDatabaseFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.availabilityZone = builder.availabilityZone;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.relationalDatabaseSnapshotName = builder.relationalDatabaseSnapshotName;
        this.relationalDatabaseBundleId = builder.relationalDatabaseBundleId;
        this.sourceRelationalDatabaseName = builder.sourceRelationalDatabaseName;
        this.restoreTime = builder.restoreTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.tags = builder.tags;
    }

    public String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String relationalDatabaseSnapshotName() {
        return this.relationalDatabaseSnapshotName;
    }

    public String relationalDatabaseBundleId() {
        return this.relationalDatabaseBundleId;
    }

    public String sourceRelationalDatabaseName() {
        return this.sourceRelationalDatabaseName;
    }

    public Instant restoreTime() {
        return this.restoreTime;
    }

    public Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRelationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationalDatabaseFromSnapshotRequest)) {
            return false;
        }
        CreateRelationalDatabaseFromSnapshotRequest other = (CreateRelationalDatabaseFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.relationalDatabaseSnapshotName(), other.relationalDatabaseSnapshotName()) && Objects.equals(this.relationalDatabaseBundleId(), other.relationalDatabaseBundleId()) && Objects.equals(this.sourceRelationalDatabaseName(), other.sourceRelationalDatabaseName()) && Objects.equals(this.restoreTime(), other.restoreTime()) && Objects.equals(this.useLatestRestorableTime(), other.useLatestRestorableTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateRelationalDatabaseFromSnapshotRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("RelationalDatabaseSnapshotName", (Object)this.relationalDatabaseSnapshotName()).add("RelationalDatabaseBundleId", (Object)this.relationalDatabaseBundleId()).add("SourceRelationalDatabaseName", (Object)this.sourceRelationalDatabaseName()).add("RestoreTime", (Object)this.restoreTime()).add("UseLatestRestorableTime", (Object)this.useLatestRestorableTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "relationalDatabaseSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseSnapshotName()));
            }
            case "relationalDatabaseBundleId": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseBundleId()));
            }
            case "sourceRelationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.sourceRelationalDatabaseName()));
            }
            case "restoreTime": {
                return Optional.ofNullable(clazz.cast(this.restoreTime()));
            }
            case "useLatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationalDatabaseFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateRelationalDatabaseFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private String availabilityZone;
        private Boolean publiclyAccessible;
        private String relationalDatabaseSnapshotName;
        private String relationalDatabaseBundleId;
        private String sourceRelationalDatabaseName;
        private Instant restoreTime;
        private Boolean useLatestRestorableTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationalDatabaseFromSnapshotRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.availabilityZone(model.availabilityZone);
            this.publiclyAccessible(model.publiclyAccessible);
            this.relationalDatabaseSnapshotName(model.relationalDatabaseSnapshotName);
            this.relationalDatabaseBundleId(model.relationalDatabaseBundleId);
            this.sourceRelationalDatabaseName(model.sourceRelationalDatabaseName);
            this.restoreTime(model.restoreTime);
            this.useLatestRestorableTime(model.useLatestRestorableTime);
            this.tags(model.tags);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getRelationalDatabaseSnapshotName() {
            return this.relationalDatabaseSnapshotName;
        }

        @Override
        public final Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
            return this;
        }

        public final void setRelationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
        }

        public final String getRelationalDatabaseBundleId() {
            return this.relationalDatabaseBundleId;
        }

        @Override
        public final Builder relationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
            return this;
        }

        public final void setRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
        }

        public final String getSourceRelationalDatabaseName() {
            return this.sourceRelationalDatabaseName;
        }

        @Override
        public final Builder sourceRelationalDatabaseName(String sourceRelationalDatabaseName) {
            this.sourceRelationalDatabaseName = sourceRelationalDatabaseName;
            return this;
        }

        public final void setSourceRelationalDatabaseName(String sourceRelationalDatabaseName) {
            this.sourceRelationalDatabaseName = sourceRelationalDatabaseName;
        }

        public final Instant getRestoreTime() {
            return this.restoreTime;
        }

        @Override
        public final Builder restoreTime(Instant restoreTime) {
            this.restoreTime = restoreTime;
            return this;
        }

        public final void setRestoreTime(Instant restoreTime) {
            this.restoreTime = restoreTime;
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationalDatabaseFromSnapshotRequest build() {
            return new CreateRelationalDatabaseFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRelationalDatabaseFromSnapshotRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder availabilityZone(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder relationalDatabaseSnapshotName(String var1);

        public Builder relationalDatabaseBundleId(String var1);

        public Builder sourceRelationalDatabaseName(String var1);

        public Builder restoreTime(Instant var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

