/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExportSnapshotRecordsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetExportSnapshotRecordsResponse> {
    private static final SdkField<List<ExportSnapshotRecord>> EXPORT_SNAPSHOT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportSnapshotRecords").getter(GetExportSnapshotRecordsResponse.getter(GetExportSnapshotRecordsResponse::exportSnapshotRecords)).setter(GetExportSnapshotRecordsResponse.setter(Builder::exportSnapshotRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportSnapshotRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportSnapshotRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetExportSnapshotRecordsResponse.getter(GetExportSnapshotRecordsResponse::nextPageToken)).setter(GetExportSnapshotRecordsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_SNAPSHOT_RECORDS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ExportSnapshotRecord> exportSnapshotRecords;
    private final String nextPageToken;

    private GetExportSnapshotRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.exportSnapshotRecords = builder.exportSnapshotRecords;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasExportSnapshotRecords() {
        return this.exportSnapshotRecords != null && !(this.exportSnapshotRecords instanceof SdkAutoConstructList);
    }

    public List<ExportSnapshotRecord> exportSnapshotRecords() {
        return this.exportSnapshotRecords;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportSnapshotRecords() ? this.exportSnapshotRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportSnapshotRecordsResponse)) {
            return false;
        }
        GetExportSnapshotRecordsResponse other = (GetExportSnapshotRecordsResponse)((Object)obj);
        return this.hasExportSnapshotRecords() == other.hasExportSnapshotRecords() && Objects.equals(this.exportSnapshotRecords(), other.exportSnapshotRecords()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetExportSnapshotRecordsResponse").add("ExportSnapshotRecords", this.hasExportSnapshotRecords() ? this.exportSnapshotRecords() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportSnapshotRecords": {
                return Optional.ofNullable(clazz.cast(this.exportSnapshotRecords()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportSnapshotRecordsResponse, T> g) {
        return obj -> g.apply((GetExportSnapshotRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ExportSnapshotRecord> exportSnapshotRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportSnapshotRecordsResponse model) {
            super(model);
            this.exportSnapshotRecords(model.exportSnapshotRecords);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ExportSnapshotRecord.Builder> getExportSnapshotRecords() {
            if (this.exportSnapshotRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportSnapshotRecords != null ? (Collection)this.exportSnapshotRecords.stream().map(ExportSnapshotRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportSnapshotRecords(Collection<ExportSnapshotRecord> exportSnapshotRecords) {
            this.exportSnapshotRecords = ExportSnapshotRecordListCopier.copy(exportSnapshotRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSnapshotRecords(ExportSnapshotRecord ... exportSnapshotRecords) {
            this.exportSnapshotRecords(Arrays.asList(exportSnapshotRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSnapshotRecords(Consumer<ExportSnapshotRecord.Builder> ... exportSnapshotRecords) {
            this.exportSnapshotRecords(Stream.of(exportSnapshotRecords).map(c -> (ExportSnapshotRecord)((ExportSnapshotRecord.Builder)ExportSnapshotRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportSnapshotRecords(Collection<ExportSnapshotRecord.BuilderImpl> exportSnapshotRecords) {
            this.exportSnapshotRecords = ExportSnapshotRecordListCopier.copyFromBuilder(exportSnapshotRecords);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetExportSnapshotRecordsResponse build() {
            return new GetExportSnapshotRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExportSnapshotRecordsResponse> {
        public Builder exportSnapshotRecords(Collection<ExportSnapshotRecord> var1);

        public Builder exportSnapshotRecords(ExportSnapshotRecord ... var1);

        public Builder exportSnapshotRecords(Consumer<ExportSnapshotRecord.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

