/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CertificateStatus;
import software.amazon.awssdk.services.lightsail.model.DomainValidationRecord;
import software.amazon.awssdk.services.lightsail.model.DomainValidationRecordListCopier;
import software.amazon.awssdk.services.lightsail.model.RenewalSummary;
import software.amazon.awssdk.services.lightsail.model.SubjectAlternativeNameListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Certificate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Certificate.getter(Certificate::arn)).setter(Certificate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Certificate.getter(Certificate::name)).setter(Certificate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(Certificate.getter(Certificate::domainName)).setter(Certificate.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Certificate.getter(Certificate::statusAsString)).setter(Certificate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serialNumber").getter(Certificate.getter(Certificate::serialNumber)).setter(Certificate.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()}).build();
    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subjectAlternativeNames").getter(Certificate.getter(Certificate::subjectAlternativeNames)).setter(Certificate.setter(Builder::subjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DomainValidationRecord>> DOMAIN_VALIDATION_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainValidationRecords").getter(Certificate.getter(Certificate::domainValidationRecords)).setter(Certificate.setter(Builder::domainValidationRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainValidationRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestFailureReason").getter(Certificate.getter(Certificate::requestFailureReason)).setter(Certificate.setter(Builder::requestFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestFailureReason").build()}).build();
    private static final SdkField<Integer> IN_USE_RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inUseResourceCount").getter(Certificate.getter(Certificate::inUseResourceCount)).setter(Certificate.setter(Builder::inUseResourceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseResourceCount").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyAlgorithm").getter(Certificate.getter(Certificate::keyAlgorithm)).setter(Certificate.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyAlgorithm").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Certificate.getter(Certificate::createdAt)).setter(Certificate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("issuedAt").getter(Certificate.getter(Certificate::issuedAt)).setter(Certificate.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuedAt").build()}).build();
    private static final SdkField<String> ISSUER_CA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerCA").getter(Certificate.getter(Certificate::issuerCA)).setter(Certificate.setter(Builder::issuerCA)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCA").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notBefore").getter(Certificate.getter(Certificate::notBefore)).setter(Certificate.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notBefore").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notAfter").getter(Certificate.getter(Certificate::notAfter)).setter(Certificate.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notAfter").build()}).build();
    private static final SdkField<String> ELIGIBLE_TO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eligibleToRenew").getter(Certificate.getter(Certificate::eligibleToRenew)).setter(Certificate.setter(Builder::eligibleToRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eligibleToRenew").build()}).build();
    private static final SdkField<RenewalSummary> RENEWAL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renewalSummary").getter(Certificate.getter(Certificate::renewalSummary)).setter(Certificate.setter(Builder::renewalSummary)).constructor(RenewalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalSummary").build()}).build();
    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("revokedAt").getter(Certificate.getter(Certificate::revokedAt)).setter(Certificate.setter(Builder::revokedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedAt").build()}).build();
    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revocationReason").getter(Certificate.getter(Certificate::revocationReason)).setter(Certificate.setter(Builder::revocationReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Certificate.getter(Certificate::tags)).setter(Certificate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(Certificate.getter(Certificate::supportCode)).setter(Certificate.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DOMAIN_NAME_FIELD, STATUS_FIELD, SERIAL_NUMBER_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD, DOMAIN_VALIDATION_RECORDS_FIELD, REQUEST_FAILURE_REASON_FIELD, IN_USE_RESOURCE_COUNT_FIELD, KEY_ALGORITHM_FIELD, CREATED_AT_FIELD, ISSUED_AT_FIELD, ISSUER_CA_FIELD, NOT_BEFORE_FIELD, NOT_AFTER_FIELD, ELIGIBLE_TO_RENEW_FIELD, RENEWAL_SUMMARY_FIELD, REVOKED_AT_FIELD, REVOCATION_REASON_FIELD, TAGS_FIELD, SUPPORT_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String domainName;
    private final String status;
    private final String serialNumber;
    private final List<String> subjectAlternativeNames;
    private final List<DomainValidationRecord> domainValidationRecords;
    private final String requestFailureReason;
    private final Integer inUseResourceCount;
    private final String keyAlgorithm;
    private final Instant createdAt;
    private final Instant issuedAt;
    private final String issuerCA;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String eligibleToRenew;
    private final RenewalSummary renewalSummary;
    private final Instant revokedAt;
    private final String revocationReason;
    private final List<Tag> tags;
    private final String supportCode;

    private Certificate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.domainName = builder.domainName;
        this.status = builder.status;
        this.serialNumber = builder.serialNumber;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.domainValidationRecords = builder.domainValidationRecords;
        this.requestFailureReason = builder.requestFailureReason;
        this.inUseResourceCount = builder.inUseResourceCount;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.createdAt = builder.createdAt;
        this.issuedAt = builder.issuedAt;
        this.issuerCA = builder.issuerCA;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.eligibleToRenew = builder.eligibleToRenew;
        this.renewalSummary = builder.renewalSummary;
        this.revokedAt = builder.revokedAt;
        this.revocationReason = builder.revocationReason;
        this.tags = builder.tags;
        this.supportCode = builder.supportCode;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String domainName() {
        return this.domainName;
    }

    public CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public boolean hasSubjectAlternativeNames() {
        return this.subjectAlternativeNames != null && !(this.subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public boolean hasDomainValidationRecords() {
        return this.domainValidationRecords != null && !(this.domainValidationRecords instanceof SdkAutoConstructList);
    }

    public List<DomainValidationRecord> domainValidationRecords() {
        return this.domainValidationRecords;
    }

    public String requestFailureReason() {
        return this.requestFailureReason;
    }

    public Integer inUseResourceCount() {
        return this.inUseResourceCount;
    }

    public String keyAlgorithm() {
        return this.keyAlgorithm;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant issuedAt() {
        return this.issuedAt;
    }

    public String issuerCA() {
        return this.issuerCA;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public String eligibleToRenew() {
        return this.eligibleToRenew;
    }

    public RenewalSummary renewalSummary() {
        return this.renewalSummary;
    }

    public Instant revokedAt() {
        return this.revokedAt;
    }

    public String revocationReason() {
        return this.revocationReason;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationRecords() ? this.domainValidationRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerCA());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.eligibleToRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.serialNumber(), other.serialNumber()) && this.hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames() && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && this.hasDomainValidationRecords() == other.hasDomainValidationRecords() && Objects.equals(this.domainValidationRecords(), other.domainValidationRecords()) && Objects.equals(this.requestFailureReason(), other.requestFailureReason()) && Objects.equals(this.inUseResourceCount(), other.inUseResourceCount()) && Objects.equals(this.keyAlgorithm(), other.keyAlgorithm()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.issuerCA(), other.issuerCA()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.eligibleToRenew(), other.eligibleToRenew()) && Objects.equals(this.renewalSummary(), other.renewalSummary()) && Objects.equals(this.revokedAt(), other.revokedAt()) && Objects.equals(this.revocationReason(), other.revocationReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.supportCode(), other.supportCode());
    }

    public String toString() {
        return ToString.builder((String)"Certificate").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("DomainName", (Object)this.domainName()).add("Status", (Object)this.statusAsString()).add("SerialNumber", (Object)this.serialNumber()).add("SubjectAlternativeNames", this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null).add("DomainValidationRecords", this.hasDomainValidationRecords() ? this.domainValidationRecords() : null).add("RequestFailureReason", (Object)this.requestFailureReason()).add("InUseResourceCount", (Object)this.inUseResourceCount()).add("KeyAlgorithm", (Object)this.keyAlgorithm()).add("CreatedAt", (Object)this.createdAt()).add("IssuedAt", (Object)this.issuedAt()).add("IssuerCA", (Object)this.issuerCA()).add("NotBefore", (Object)this.notBefore()).add("NotAfter", (Object)this.notAfter()).add("EligibleToRenew", (Object)this.eligibleToRenew()).add("RenewalSummary", (Object)this.renewalSummary()).add("RevokedAt", (Object)this.revokedAt()).add("RevocationReason", (Object)this.revocationReason()).add("Tags", this.hasTags() ? this.tags() : null).add("SupportCode", (Object)this.supportCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "serialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "subjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
            case "domainValidationRecords": {
                return Optional.ofNullable(clazz.cast(this.domainValidationRecords()));
            }
            case "requestFailureReason": {
                return Optional.ofNullable(clazz.cast(this.requestFailureReason()));
            }
            case "inUseResourceCount": {
                return Optional.ofNullable(clazz.cast(this.inUseResourceCount()));
            }
            case "keyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithm()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "issuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "issuerCA": {
                return Optional.ofNullable(clazz.cast(this.issuerCA()));
            }
            case "notBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "notAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "eligibleToRenew": {
                return Optional.ofNullable(clazz.cast(this.eligibleToRenew()));
            }
            case "renewalSummary": {
                return Optional.ofNullable(clazz.cast(this.renewalSummary()));
            }
            case "revokedAt": {
                return Optional.ofNullable(clazz.cast(this.revokedAt()));
            }
            case "revocationReason": {
                return Optional.ofNullable(clazz.cast(this.revocationReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String domainName;
        private String status;
        private String serialNumber;
        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private List<DomainValidationRecord> domainValidationRecords = DefaultSdkAutoConstructList.getInstance();
        private String requestFailureReason;
        private Integer inUseResourceCount;
        private String keyAlgorithm;
        private Instant createdAt;
        private Instant issuedAt;
        private String issuerCA;
        private Instant notBefore;
        private Instant notAfter;
        private String eligibleToRenew;
        private RenewalSummary renewalSummary;
        private Instant revokedAt;
        private String revocationReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String supportCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.arn(model.arn);
            this.name(model.name);
            this.domainName(model.domainName);
            this.status(model.status);
            this.serialNumber(model.serialNumber);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.domainValidationRecords(model.domainValidationRecords);
            this.requestFailureReason(model.requestFailureReason);
            this.inUseResourceCount(model.inUseResourceCount);
            this.keyAlgorithm(model.keyAlgorithm);
            this.createdAt(model.createdAt);
            this.issuedAt(model.issuedAt);
            this.issuerCA(model.issuerCA);
            this.notBefore(model.notBefore);
            this.notAfter(model.notAfter);
            this.eligibleToRenew(model.eligibleToRenew);
            this.renewalSummary(model.renewalSummary);
            this.revokedAt(model.revokedAt);
            this.revocationReason(model.revocationReason);
            this.tags(model.tags);
            this.supportCode(model.supportCode);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            if (this.subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = SubjectAlternativeNameListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = SubjectAlternativeNameListCopier.copy(subjectAlternativeNames);
        }

        public final Collection<DomainValidationRecord.Builder> getDomainValidationRecords() {
            if (this.domainValidationRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainValidationRecords != null ? (Collection)this.domainValidationRecords.stream().map(DomainValidationRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
            this.domainValidationRecords = DomainValidationRecordListCopier.copy(domainValidationRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(DomainValidationRecord ... domainValidationRecords) {
            this.domainValidationRecords(Arrays.asList(domainValidationRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(Consumer<DomainValidationRecord.Builder> ... domainValidationRecords) {
            this.domainValidationRecords(Stream.of(domainValidationRecords).map(c -> (DomainValidationRecord)((DomainValidationRecord.Builder)DomainValidationRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationRecords(Collection<DomainValidationRecord.BuilderImpl> domainValidationRecords) {
            this.domainValidationRecords = DomainValidationRecordListCopier.copyFromBuilder(domainValidationRecords);
        }

        public final String getRequestFailureReason() {
            return this.requestFailureReason;
        }

        @Override
        public final Builder requestFailureReason(String requestFailureReason) {
            this.requestFailureReason = requestFailureReason;
            return this;
        }

        public final void setRequestFailureReason(String requestFailureReason) {
            this.requestFailureReason = requestFailureReason;
        }

        public final Integer getInUseResourceCount() {
            return this.inUseResourceCount;
        }

        @Override
        public final Builder inUseResourceCount(Integer inUseResourceCount) {
            this.inUseResourceCount = inUseResourceCount;
            return this;
        }

        public final void setInUseResourceCount(Integer inUseResourceCount) {
            this.inUseResourceCount = inUseResourceCount;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        public final String getIssuerCA() {
            return this.issuerCA;
        }

        @Override
        public final Builder issuerCA(String issuerCA) {
            this.issuerCA = issuerCA;
            return this;
        }

        public final void setIssuerCA(String issuerCA) {
            this.issuerCA = issuerCA;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final String getEligibleToRenew() {
            return this.eligibleToRenew;
        }

        @Override
        public final Builder eligibleToRenew(String eligibleToRenew) {
            this.eligibleToRenew = eligibleToRenew;
            return this;
        }

        public final void setEligibleToRenew(String eligibleToRenew) {
            this.eligibleToRenew = eligibleToRenew;
        }

        public final RenewalSummary.Builder getRenewalSummary() {
            return this.renewalSummary != null ? this.renewalSummary.toBuilder() : null;
        }

        @Override
        public final Builder renewalSummary(RenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final void setRenewalSummary(RenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        public final Instant getRevokedAt() {
            return this.revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public Certificate build() {
            return new Certificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Certificate> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder domainName(String var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder serialNumber(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder domainValidationRecords(Collection<DomainValidationRecord> var1);

        public Builder domainValidationRecords(DomainValidationRecord ... var1);

        public Builder domainValidationRecords(Consumer<DomainValidationRecord.Builder> ... var1);

        public Builder requestFailureReason(String var1);

        public Builder inUseResourceCount(Integer var1);

        public Builder keyAlgorithm(String var1);

        public Builder createdAt(Instant var1);

        public Builder issuedAt(Instant var1);

        public Builder issuerCA(String var1);

        public Builder notBefore(Instant var1);

        public Builder notAfter(Instant var1);

        public Builder eligibleToRenew(String var1);

        public Builder renewalSummary(RenewalSummary var1);

        default public Builder renewalSummary(Consumer<RenewalSummary.Builder> renewalSummary) {
            return this.renewalSummary((RenewalSummary)((RenewalSummary.Builder)RenewalSummary.builder().applyMutation(renewalSummary)).build());
        }

        public Builder revokedAt(Instant var1);

        public Builder revocationReason(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder supportCode(String var1);
    }
}

