/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ForwardValues;
import software.amazon.awssdk.services.lightsail.model.HeaderEnum;
import software.amazon.awssdk.services.lightsail.model.HeaderForwardListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HeaderObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HeaderObject> {
    private static final SdkField<String> OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("option").getter(HeaderObject.getter(HeaderObject::optionAsString)).setter(HeaderObject.setter(Builder::option)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("option").build()}).build();
    private static final SdkField<List<String>> HEADERS_ALLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headersAllowList").getter(HeaderObject.getter(HeaderObject::headersAllowListAsStrings)).setter(HeaderObject.setter(Builder::headersAllowListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headersAllowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_FIELD, HEADERS_ALLOW_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String option;
    private final List<String> headersAllowList;

    private HeaderObject(BuilderImpl builder) {
        this.option = builder.option;
        this.headersAllowList = builder.headersAllowList;
    }

    public ForwardValues option() {
        return ForwardValues.fromValue(this.option);
    }

    public String optionAsString() {
        return this.option;
    }

    public List<HeaderEnum> headersAllowList() {
        return HeaderForwardListCopier.copyStringToEnum(this.headersAllowList);
    }

    public boolean hasHeadersAllowList() {
        return this.headersAllowList != null && !(this.headersAllowList instanceof SdkAutoConstructList);
    }

    public List<String> headersAllowListAsStrings() {
        return this.headersAllowList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeadersAllowList() ? this.headersAllowListAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderObject)) {
            return false;
        }
        HeaderObject other = (HeaderObject)obj;
        return Objects.equals(this.optionAsString(), other.optionAsString()) && this.hasHeadersAllowList() == other.hasHeadersAllowList() && Objects.equals(this.headersAllowListAsStrings(), other.headersAllowListAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"HeaderObject").add("Option", (Object)this.optionAsString()).add("HeadersAllowList", this.hasHeadersAllowList() ? this.headersAllowListAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "option": {
                return Optional.ofNullable(clazz.cast(this.optionAsString()));
            }
            case "headersAllowList": {
                return Optional.ofNullable(clazz.cast(this.headersAllowListAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HeaderObject, T> g) {
        return obj -> g.apply((HeaderObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String option;
        private List<String> headersAllowList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderObject model) {
            this.option(model.option);
            this.headersAllowListWithStrings(model.headersAllowList);
        }

        public final String getOption() {
            return this.option;
        }

        @Override
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        @Override
        public final Builder option(ForwardValues option) {
            this.option(option == null ? null : option.toString());
            return this;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        public final Collection<String> getHeadersAllowList() {
            if (this.headersAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.headersAllowList;
        }

        @Override
        public final Builder headersAllowListWithStrings(Collection<String> headersAllowList) {
            this.headersAllowList = HeaderForwardListCopier.copy(headersAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headersAllowListWithStrings(String ... headersAllowList) {
            this.headersAllowListWithStrings(Arrays.asList(headersAllowList));
            return this;
        }

        @Override
        public final Builder headersAllowList(Collection<HeaderEnum> headersAllowList) {
            this.headersAllowList = HeaderForwardListCopier.copyEnumToString(headersAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headersAllowList(HeaderEnum ... headersAllowList) {
            this.headersAllowList(Arrays.asList(headersAllowList));
            return this;
        }

        public final void setHeadersAllowList(Collection<String> headersAllowList) {
            this.headersAllowList = HeaderForwardListCopier.copy(headersAllowList);
        }

        public HeaderObject build() {
            return new HeaderObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HeaderObject> {
        public Builder option(String var1);

        public Builder option(ForwardValues var1);

        public Builder headersAllowListWithStrings(Collection<String> var1);

        public Builder headersAllowListWithStrings(String ... var1);

        public Builder headersAllowList(Collection<HeaderEnum> var1);

        public Builder headersAllowList(HeaderEnum ... var1);
    }
}

