/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ForwardValues;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CookieObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CookieObject> {
    private static final SdkField<String> OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CookieObject.getter(CookieObject::optionAsString)).setter(CookieObject.setter(Builder::option)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("option").build()}).build();
    private static final SdkField<List<String>> COOKIES_ALLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CookieObject.getter(CookieObject::cookiesAllowList)).setter(CookieObject.setter(Builder::cookiesAllowList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cookiesAllowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_FIELD, COOKIES_ALLOW_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String option;
    private final List<String> cookiesAllowList;

    private CookieObject(BuilderImpl builder) {
        this.option = builder.option;
        this.cookiesAllowList = builder.cookiesAllowList;
    }

    public ForwardValues option() {
        return ForwardValues.fromValue(this.option);
    }

    public String optionAsString() {
        return this.option;
    }

    public boolean hasCookiesAllowList() {
        return this.cookiesAllowList != null && !(this.cookiesAllowList instanceof SdkAutoConstructList);
    }

    public List<String> cookiesAllowList() {
        return this.cookiesAllowList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookiesAllowList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieObject)) {
            return false;
        }
        CookieObject other = (CookieObject)obj;
        return Objects.equals(this.optionAsString(), other.optionAsString()) && Objects.equals(this.cookiesAllowList(), other.cookiesAllowList());
    }

    public String toString() {
        return ToString.builder((String)"CookieObject").add("Option", (Object)this.optionAsString()).add("CookiesAllowList", this.cookiesAllowList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "option": {
                return Optional.ofNullable(clazz.cast(this.optionAsString()));
            }
            case "cookiesAllowList": {
                return Optional.ofNullable(clazz.cast(this.cookiesAllowList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CookieObject, T> g) {
        return obj -> g.apply((CookieObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String option;
        private List<String> cookiesAllowList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CookieObject model) {
            this.option(model.option);
            this.cookiesAllowList(model.cookiesAllowList);
        }

        public final String getOption() {
            return this.option;
        }

        @Override
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        @Override
        public final Builder option(ForwardValues option) {
            this.option(option == null ? null : option.toString());
            return this;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        public final Collection<String> getCookiesAllowList() {
            return this.cookiesAllowList;
        }

        @Override
        public final Builder cookiesAllowList(Collection<String> cookiesAllowList) {
            this.cookiesAllowList = StringListCopier.copy(cookiesAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cookiesAllowList(String ... cookiesAllowList) {
            this.cookiesAllowList(Arrays.asList(cookiesAllowList));
            return this;
        }

        public final void setCookiesAllowList(Collection<String> cookiesAllowList) {
            this.cookiesAllowList = StringListCopier.copy(cookiesAllowList);
        }

        public CookieObject build() {
            return new CookieObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CookieObject> {
        public Builder option(String var1);

        public Builder option(ForwardValues var1);

        public Builder cookiesAllowList(Collection<String> var1);

        public Builder cookiesAllowList(String ... var1);
    }
}

