/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails;
import software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetailsListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAutoSnapshotsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetAutoSnapshotsResponse> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAutoSnapshotsResponse.getter(GetAutoSnapshotsResponse::resourceName)).setter(GetAutoSnapshotsResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAutoSnapshotsResponse.getter(GetAutoSnapshotsResponse::resourceTypeAsString)).setter(GetAutoSnapshotsResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<AutoSnapshotDetails>> AUTO_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAutoSnapshotsResponse.getter(GetAutoSnapshotsResponse::autoSnapshots)).setter(GetAutoSnapshotsResponse.setter(Builder::autoSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoSnapshotDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, AUTO_SNAPSHOTS_FIELD));
    private final String resourceName;
    private final String resourceType;
    private final List<AutoSnapshotDetails> autoSnapshots;

    private GetAutoSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.autoSnapshots = builder.autoSnapshots;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public boolean hasAutoSnapshots() {
        return this.autoSnapshots != null && !(this.autoSnapshots instanceof SdkAutoConstructList);
    }

    public List<AutoSnapshotDetails> autoSnapshots() {
        return this.autoSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoSnapshots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoSnapshotsResponse)) {
            return false;
        }
        GetAutoSnapshotsResponse other = (GetAutoSnapshotsResponse)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.autoSnapshots(), other.autoSnapshots());
    }

    public String toString() {
        return ToString.builder((String)"GetAutoSnapshotsResponse").add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceTypeAsString()).add("AutoSnapshots", this.autoSnapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "autoSnapshots": {
                return Optional.ofNullable(clazz.cast(this.autoSnapshots()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoSnapshotsResponse, T> g) {
        return obj -> g.apply((GetAutoSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String resourceName;
        private String resourceType;
        private List<AutoSnapshotDetails> autoSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoSnapshotsResponse model) {
            super(model);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.autoSnapshots(model.autoSnapshots);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<AutoSnapshotDetails.Builder> getAutoSnapshots() {
            return this.autoSnapshots != null ? (Collection)this.autoSnapshots.stream().map(AutoSnapshotDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoSnapshots(Collection<AutoSnapshotDetails> autoSnapshots) {
            this.autoSnapshots = AutoSnapshotDetailsListCopier.copy(autoSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoSnapshots(AutoSnapshotDetails ... autoSnapshots) {
            this.autoSnapshots(Arrays.asList(autoSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoSnapshots(Consumer<AutoSnapshotDetails.Builder> ... autoSnapshots) {
            this.autoSnapshots(Stream.of(autoSnapshots).map(c -> (AutoSnapshotDetails)((AutoSnapshotDetails.Builder)AutoSnapshotDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoSnapshots(Collection<AutoSnapshotDetails.BuilderImpl> autoSnapshots) {
            this.autoSnapshots = AutoSnapshotDetailsListCopier.copyFromBuilder(autoSnapshots);
        }

        @Override
        public GetAutoSnapshotsResponse build() {
            return new GetAutoSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAutoSnapshotsResponse> {
        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder autoSnapshots(Collection<AutoSnapshotDetails> var1);

        public Builder autoSnapshots(AutoSnapshotDetails ... var1);

        public Builder autoSnapshots(Consumer<AutoSnapshotDetails.Builder> ... var1);
    }
}

