/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AttachedDisk;
import software.amazon.awssdk.services.lightsail.model.AttachedDiskListCopier;
import software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoSnapshotDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoSnapshotDetails> {
    private static final SdkField<String> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoSnapshotDetails.getter(AutoSnapshotDetails::date)).setter(AutoSnapshotDetails.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutoSnapshotDetails.getter(AutoSnapshotDetails::createdAt)).setter(AutoSnapshotDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoSnapshotDetails.getter(AutoSnapshotDetails::statusAsString)).setter(AutoSnapshotDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<AttachedDisk>> FROM_ATTACHED_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoSnapshotDetails.getter(AutoSnapshotDetails::fromAttachedDisks)).setter(AutoSnapshotDetails.setter(Builder::fromAttachedDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromAttachedDisks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachedDisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, CREATED_AT_FIELD, STATUS_FIELD, FROM_ATTACHED_DISKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String date;
    private final Instant createdAt;
    private final String status;
    private final List<AttachedDisk> fromAttachedDisks;

    private AutoSnapshotDetails(BuilderImpl builder) {
        this.date = builder.date;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.fromAttachedDisks = builder.fromAttachedDisks;
    }

    public String date() {
        return this.date;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public AutoSnapshotStatus status() {
        return AutoSnapshotStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<AttachedDisk> fromAttachedDisks() {
        return this.fromAttachedDisks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAttachedDisks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoSnapshotDetails)) {
            return false;
        }
        AutoSnapshotDetails other = (AutoSnapshotDetails)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fromAttachedDisks(), other.fromAttachedDisks());
    }

    public String toString() {
        return ToString.builder((String)"AutoSnapshotDetails").add("Date", (Object)this.date()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("FromAttachedDisks", this.fromAttachedDisks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "fromAttachedDisks": {
                return Optional.ofNullable(clazz.cast(this.fromAttachedDisks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoSnapshotDetails, T> g) {
        return obj -> g.apply((AutoSnapshotDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String date;
        private Instant createdAt;
        private String status;
        private List<AttachedDisk> fromAttachedDisks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoSnapshotDetails model) {
            this.date(model.date);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.fromAttachedDisks(model.fromAttachedDisks);
        }

        public final String getDate() {
            return this.date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutoSnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<AttachedDisk.Builder> getFromAttachedDisks() {
            return this.fromAttachedDisks != null ? (Collection)this.fromAttachedDisks.stream().map(AttachedDisk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fromAttachedDisks(Collection<AttachedDisk> fromAttachedDisks) {
            this.fromAttachedDisks = AttachedDiskListCopier.copy(fromAttachedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(AttachedDisk ... fromAttachedDisks) {
            this.fromAttachedDisks(Arrays.asList(fromAttachedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(Consumer<AttachedDisk.Builder> ... fromAttachedDisks) {
            this.fromAttachedDisks(Stream.of(fromAttachedDisks).map(c -> (AttachedDisk)((AttachedDisk.Builder)AttachedDisk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFromAttachedDisks(Collection<AttachedDisk.BuilderImpl> fromAttachedDisks) {
            this.fromAttachedDisks = AttachedDiskListCopier.copyFromBuilder(fromAttachedDisks);
        }

        public AutoSnapshotDetails build() {
            return new AutoSnapshotDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoSnapshotDetails> {
        public Builder date(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(AutoSnapshotStatus var1);

        public Builder fromAttachedDisks(Collection<AttachedDisk> var1);

        public Builder fromAttachedDisks(AttachedDisk ... var1);

        public Builder fromAttachedDisks(Consumer<AttachedDisk.Builder> ... var1);
    }
}

