/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceLocation> {
    private final String availabilityZone;
    private final String regionName;

    private ResourceLocation(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.regionName = builder.regionName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public RegionName regionName() {
        return RegionName.fromValue(this.regionName);
    }

    public String regionNameString() {
        return this.regionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionNameString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation other = (ResourceLocation)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.regionNameString(), other.regionNameString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.regionNameString() != null) {
            sb.append("RegionName: ").append(this.regionNameString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "regionName": {
                return Optional.of(clazz.cast(this.regionNameString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLocation model) {
            this.availabilityZone(model.availabilityZone);
            this.regionName(model.regionName);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public final Builder regionName(RegionName regionName) {
            this.regionName(regionName.toString());
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public ResourceLocation build() {
            return new ResourceLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceLocation> {
        public Builder availabilityZone(String var1);

        public Builder regionName(String var1);

        public Builder regionName(RegionName var1);
    }
}

