/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOperationsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetOperationsResponse> {
    private final List<Operation> operations;
    private final String nextPageToken;

    private GetOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsResponse)) {
            return false;
        }
        GetOperationsResponse other = (GetOperationsResponse)((Object)obj);
        return Objects.equals(this.operations(), other.operations()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operations": {
                return Optional.of(clazz.cast(this.operations()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Operation> operations;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsResponse model) {
            this.operations(model.operations);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<Operation.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetOperationsResponse build() {
            return new GetOperationsResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetOperationsResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder nextPageToken(String var1);
    }
}

