/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshotState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.DiskSnapshotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiskSnapshot
implements StructuredPojo,
ToCopyableBuilder<Builder, DiskSnapshot> {
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final Integer sizeInGb;
    private final String state;
    private final String progress;
    private final String fromDiskName;
    private final String fromDiskArn;

    private DiskSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.sizeInGb = builder.sizeInGb;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromDiskName = builder.fromDiskName;
        this.fromDiskArn = builder.fromDiskArn;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public DiskSnapshotState state() {
        return DiskSnapshotState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String progress() {
        return this.progress;
    }

    public String fromDiskName() {
        return this.fromDiskName;
    }

    public String fromDiskArn() {
        return this.fromDiskArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDiskArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskSnapshot)) {
            return false;
        }
        DiskSnapshot other = (DiskSnapshot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.fromDiskName(), other.fromDiskName()) && Objects.equals(this.fromDiskArn(), other.fromDiskArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.supportCode() != null) {
            sb.append("SupportCode: ").append(this.supportCode()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.sizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.sizeInGb()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.progress() != null) {
            sb.append("Progress: ").append(this.progress()).append(",");
        }
        if (this.fromDiskName() != null) {
            sb.append("FromDiskName: ").append(this.fromDiskName()).append(",");
        }
        if (this.fromDiskArn() != null) {
            sb.append("FromDiskArn: ").append(this.fromDiskArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.of(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "sizeInGb": {
                return Optional.of(clazz.cast(this.sizeInGb()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "progress": {
                return Optional.of(clazz.cast(this.progress()));
            }
            case "fromDiskName": {
                return Optional.of(clazz.cast(this.fromDiskName()));
            }
            case "fromDiskArn": {
                return Optional.of(clazz.cast(this.fromDiskArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private Integer sizeInGb;
        private String state;
        private String progress;
        private String fromDiskName;
        private String fromDiskArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskSnapshot model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.sizeInGb(model.sizeInGb);
            this.state(model.state);
            this.progress(model.progress);
            this.fromDiskName(model.fromDiskName);
            this.fromDiskArn(model.fromDiskArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiskSnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getFromDiskName() {
            return this.fromDiskName;
        }

        @Override
        public final Builder fromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
            return this;
        }

        public final void setFromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
        }

        public final String getFromDiskArn() {
            return this.fromDiskArn;
        }

        @Override
        public final Builder fromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
            return this;
        }

        public final void setFromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
        }

        public DiskSnapshot build() {
            return new DiskSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiskSnapshot> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().apply(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder sizeInGb(Integer var1);

        public Builder state(String var1);

        public Builder state(DiskSnapshotState var1);

        public Builder progress(String var1);

        public Builder fromDiskName(String var1);

        public Builder fromDiskArn(String var1);
    }
}

