/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstancesRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateInstancesRequest> {
    private final List<String> instanceNames;
    private final String availabilityZone;
    private final String customImageName;
    private final String blueprintId;
    private final String bundleId;
    private final String userData;
    private final String keyPairName;

    private CreateInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.customImageName = builder.customImageName;
        this.blueprintId = builder.blueprintId;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String customImageName() {
        return this.customImageName;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String userData() {
        return this.userData;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.customImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesRequest)) {
            return false;
        }
        CreateInstancesRequest other = (CreateInstancesRequest)((Object)obj);
        return Objects.equals(this.instanceNames(), other.instanceNames()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.customImageName(), other.customImageName()) && Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.keyPairName(), other.keyPairName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.customImageName() != null) {
            sb.append("CustomImageName: ").append(this.customImageName()).append(",");
        }
        if (this.blueprintId() != null) {
            sb.append("BlueprintId: ").append(this.blueprintId()).append(",");
        }
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.keyPairName() != null) {
            sb.append("KeyPairName: ").append(this.keyPairName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.of(clazz.cast(this.instanceNames()));
            }
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "customImageName": {
                return Optional.of(clazz.cast(this.customImageName()));
            }
            case "blueprintId": {
                return Optional.of(clazz.cast(this.blueprintId()));
            }
            case "bundleId": {
                return Optional.of(clazz.cast(this.bundleId()));
            }
            case "userData": {
                return Optional.of(clazz.cast(this.userData()));
            }
            case "keyPairName": {
                return Optional.of(clazz.cast(this.keyPairName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<String> instanceNames;
        private String availabilityZone;
        private String customImageName;
        private String blueprintId;
        private String bundleId;
        private String userData;
        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesRequest model) {
            this.instanceNames(model.instanceNames);
            this.availabilityZone(model.availabilityZone);
            this.customImageName(model.customImageName);
            this.blueprintId(model.blueprintId);
            this.bundleId(model.bundleId);
            this.userData(model.userData);
            this.keyPairName(model.keyPairName);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCustomImageName() {
            return this.customImageName;
        }

        @Override
        public final Builder customImageName(String customImageName) {
            this.customImageName = customImageName;
            return this;
        }

        public final void setCustomImageName(String customImageName) {
            this.customImageName = customImageName;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesRequest build() {
            return new CreateInstancesRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, CreateInstancesRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder customImageName(String var1);

        public Builder blueprintId(String var1);

        public Builder bundleId(String var1);

        public Builder userData(String var1);

        public Builder keyPairName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

