/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Blueprint;
import software.amazon.awssdk.services.lightsail.model.BlueprintListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBlueprintsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBlueprintsResponse> {
    private final List<Blueprint> blueprints;
    private final String nextPageToken;

    private GetBlueprintsResponse(BuilderImpl builder) {
        this.blueprints = builder.blueprints;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Blueprint> blueprints() {
        return this.blueprints;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.blueprints() == null ? 0 : this.blueprints().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsResponse)) {
            return false;
        }
        GetBlueprintsResponse other = (GetBlueprintsResponse)((Object)obj);
        if (other.blueprints() == null ^ this.blueprints() == null) {
            return false;
        }
        if (other.blueprints() != null && !other.blueprints().equals(this.blueprints())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.blueprints() != null) {
            sb.append("Blueprints: ").append(this.blueprints()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprints": {
                return Optional.of(clazz.cast(this.blueprints()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Blueprint> blueprints;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsResponse model) {
            this.blueprints(model.blueprints);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<Blueprint.Builder> getBlueprints() {
            return this.blueprints != null ? (Collection)this.blueprints.stream().map(Blueprint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetBlueprintsResponse build() {
            return new GetBlueprintsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBlueprintsResponse> {
        public Builder blueprints(Collection<Blueprint> var1);

        public Builder blueprints(Blueprint ... var1);

        public Builder nextPageToken(String var1);
    }
}

