/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DownloadDefaultKeyPairResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DownloadDefaultKeyPairResponse> {
    private final String publicKeyBase64;
    private final String privateKeyBase64;

    private DownloadDefaultKeyPairResponse(BuilderImpl builder) {
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
    }

    public String publicKeyBase64() {
        return this.publicKeyBase64;
    }

    public String privateKeyBase64() {
        return this.privateKeyBase64;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.publicKeyBase64() == null ? 0 : this.publicKeyBase64().hashCode());
        hashCode = 31 * hashCode + (this.privateKeyBase64() == null ? 0 : this.privateKeyBase64().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDefaultKeyPairResponse)) {
            return false;
        }
        DownloadDefaultKeyPairResponse other = (DownloadDefaultKeyPairResponse)((Object)obj);
        if (other.publicKeyBase64() == null ^ this.publicKeyBase64() == null) {
            return false;
        }
        if (other.publicKeyBase64() != null && !other.publicKeyBase64().equals(this.publicKeyBase64())) {
            return false;
        }
        if (other.privateKeyBase64() == null ^ this.privateKeyBase64() == null) {
            return false;
        }
        return other.privateKeyBase64() == null || other.privateKeyBase64().equals(this.privateKeyBase64());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.publicKeyBase64() != null) {
            sb.append("PublicKeyBase64: ").append(this.publicKeyBase64()).append(",");
        }
        if (this.privateKeyBase64() != null) {
            sb.append("PrivateKeyBase64: ").append(this.privateKeyBase64()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "publicKeyBase64": {
                return Optional.of(clazz.cast(this.publicKeyBase64()));
            }
            case "privateKeyBase64": {
                return Optional.of(clazz.cast(this.privateKeyBase64()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String publicKeyBase64;
        private String privateKeyBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDefaultKeyPairResponse model) {
            this.publicKeyBase64(model.publicKeyBase64);
            this.privateKeyBase64(model.privateKeyBase64);
        }

        public final String getPublicKeyBase64() {
            return this.publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        public final String getPrivateKeyBase64() {
            return this.privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        public DownloadDefaultKeyPairResponse build() {
            return new DownloadDefaultKeyPairResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DownloadDefaultKeyPairResponse> {
        public Builder publicKeyBase64(String var1);

        public Builder privateKeyBase64(String var1);
    }
}

