/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.BlueprintType;
import software.amazon.awssdk.services.lightsail.transform.BlueprintMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Blueprint
implements StructuredPojo,
ToCopyableBuilder<Builder, Blueprint> {
    private final String blueprintId;
    private final String name;
    private final String group;
    private final String type;
    private final String description;
    private final Boolean isActive;
    private final Integer minPower;
    private final String version;
    private final String versionCode;
    private final String productUrl;
    private final String licenseUrl;

    private Blueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.name = builder.name;
        this.group = builder.group;
        this.type = builder.type;
        this.description = builder.description;
        this.isActive = builder.isActive;
        this.minPower = builder.minPower;
        this.version = builder.version;
        this.versionCode = builder.versionCode;
        this.productUrl = builder.productUrl;
        this.licenseUrl = builder.licenseUrl;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public BlueprintType type() {
        return BlueprintType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public Integer minPower() {
        return this.minPower;
    }

    public String version() {
        return this.version;
    }

    public String versionCode() {
        return this.versionCode;
    }

    public String productUrl() {
        return this.productUrl;
    }

    public String licenseUrl() {
        return this.licenseUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.blueprintId() == null ? 0 : this.blueprintId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.group() == null ? 0 : this.group().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.isActive() == null ? 0 : this.isActive().hashCode());
        hashCode = 31 * hashCode + (this.minPower() == null ? 0 : this.minPower().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.versionCode() == null ? 0 : this.versionCode().hashCode());
        hashCode = 31 * hashCode + (this.productUrl() == null ? 0 : this.productUrl().hashCode());
        hashCode = 31 * hashCode + (this.licenseUrl() == null ? 0 : this.licenseUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        if (other.blueprintId() == null ^ this.blueprintId() == null) {
            return false;
        }
        if (other.blueprintId() != null && !other.blueprintId().equals(this.blueprintId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.group() == null ^ this.group() == null) {
            return false;
        }
        if (other.group() != null && !other.group().equals(this.group())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.isActive() == null ^ this.isActive() == null) {
            return false;
        }
        if (other.isActive() != null && !other.isActive().equals(this.isActive())) {
            return false;
        }
        if (other.minPower() == null ^ this.minPower() == null) {
            return false;
        }
        if (other.minPower() != null && !other.minPower().equals(this.minPower())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.versionCode() == null ^ this.versionCode() == null) {
            return false;
        }
        if (other.versionCode() != null && !other.versionCode().equals(this.versionCode())) {
            return false;
        }
        if (other.productUrl() == null ^ this.productUrl() == null) {
            return false;
        }
        if (other.productUrl() != null && !other.productUrl().equals(this.productUrl())) {
            return false;
        }
        if (other.licenseUrl() == null ^ this.licenseUrl() == null) {
            return false;
        }
        return other.licenseUrl() == null || other.licenseUrl().equals(this.licenseUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.blueprintId() != null) {
            sb.append("BlueprintId: ").append(this.blueprintId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.group() != null) {
            sb.append("Group: ").append(this.group()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.isActive() != null) {
            sb.append("IsActive: ").append(this.isActive()).append(",");
        }
        if (this.minPower() != null) {
            sb.append("MinPower: ").append(this.minPower()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.versionCode() != null) {
            sb.append("VersionCode: ").append(this.versionCode()).append(",");
        }
        if (this.productUrl() != null) {
            sb.append("ProductUrl: ").append(this.productUrl()).append(",");
        }
        if (this.licenseUrl() != null) {
            sb.append("LicenseUrl: ").append(this.licenseUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintId": {
                return Optional.of(clazz.cast(this.blueprintId()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "group": {
                return Optional.of(clazz.cast(this.group()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "isActive": {
                return Optional.of(clazz.cast(this.isActive()));
            }
            case "minPower": {
                return Optional.of(clazz.cast(this.minPower()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "versionCode": {
                return Optional.of(clazz.cast(this.versionCode()));
            }
            case "productUrl": {
                return Optional.of(clazz.cast(this.productUrl()));
            }
            case "licenseUrl": {
                return Optional.of(clazz.cast(this.licenseUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueprintMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintId;
        private String name;
        private String group;
        private String type;
        private String description;
        private Boolean isActive;
        private Integer minPower;
        private String version;
        private String versionCode;
        private String productUrl;
        private String licenseUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            this.blueprintId(model.blueprintId);
            this.name(model.name);
            this.group(model.group);
            this.type(model.type);
            this.description(model.description);
            this.isActive(model.isActive);
            this.minPower(model.minPower);
            this.version(model.version);
            this.versionCode(model.versionCode);
            this.productUrl(model.productUrl);
            this.licenseUrl(model.licenseUrl);
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlueprintType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final Integer getMinPower() {
            return this.minPower;
        }

        @Override
        public final Builder minPower(Integer minPower) {
            this.minPower = minPower;
            return this;
        }

        public final void setMinPower(Integer minPower) {
            this.minPower = minPower;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getVersionCode() {
            return this.versionCode;
        }

        @Override
        public final Builder versionCode(String versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public final void setVersionCode(String versionCode) {
            this.versionCode = versionCode;
        }

        public final String getProductUrl() {
            return this.productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public Blueprint build() {
            return new Blueprint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Blueprint> {
        public Builder blueprintId(String var1);

        public Builder name(String var1);

        public Builder group(String var1);

        public Builder type(String var1);

        public Builder type(BlueprintType var1);

        public Builder description(String var1);

        public Builder isActive(Boolean var1);

        public Builder minPower(Integer var1);

        public Builder version(String var1);

        public Builder versionCode(String var1);

        public Builder productUrl(String var1);

        public Builder licenseUrl(String var1);
    }
}

