/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachStaticIpRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachStaticIpRequest> {
    private final String staticIpName;
    private final String instanceName;

    private AttachStaticIpRequest(BuilderImpl builder) {
        this.staticIpName = builder.staticIpName;
        this.instanceName = builder.instanceName;
    }

    public String staticIpName() {
        return this.staticIpName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.staticIpName() == null ? 0 : this.staticIpName().hashCode());
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachStaticIpRequest)) {
            return false;
        }
        AttachStaticIpRequest other = (AttachStaticIpRequest)((Object)obj);
        if (other.staticIpName() == null ^ this.staticIpName() == null) {
            return false;
        }
        if (other.staticIpName() != null && !other.staticIpName().equals(this.staticIpName())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        return other.instanceName() == null || other.instanceName().equals(this.instanceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.staticIpName() != null) {
            sb.append("StaticIpName: ").append(this.staticIpName()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "staticIpName": {
                return Optional.of(clazz.cast(this.staticIpName()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String staticIpName;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachStaticIpRequest model) {
            this.staticIpName(model.staticIpName);
            this.instanceName(model.instanceName);
        }

        public final String getStaticIpName() {
            return this.staticIpName;
        }

        @Override
        public final Builder staticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        public final void setStaticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public AttachStaticIpRequest build() {
            return new AttachStaticIpRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachStaticIpRequest> {
        public Builder staticIpName(String var1);

        public Builder instanceName(String var1);
    }
}

