/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.StaticIp;
import software.amazon.awssdk.services.lightsail.model.StaticIpListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetStaticIpsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetStaticIpsResponse> {
    private final List<StaticIp> staticIps;
    private final String nextPageToken;

    private GetStaticIpsResponse(BuilderImpl builder) {
        this.staticIps = builder.staticIps;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<StaticIp> staticIps() {
        return this.staticIps;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.staticIps() == null ? 0 : this.staticIps().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpsResponse)) {
            return false;
        }
        GetStaticIpsResponse other = (GetStaticIpsResponse)((Object)obj);
        if (other.staticIps() == null ^ this.staticIps() == null) {
            return false;
        }
        if (other.staticIps() != null && !other.staticIps().equals(this.staticIps())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.staticIps() != null) {
            sb.append("StaticIps: ").append(this.staticIps()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StaticIp> staticIps;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpsResponse model) {
            this.setStaticIps(model.staticIps);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<StaticIp> getStaticIps() {
            return this.staticIps;
        }

        @Override
        public final Builder staticIps(Collection<StaticIp> staticIps) {
            this.staticIps = StaticIpListCopier.copy(staticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticIps(StaticIp ... staticIps) {
            this.staticIps(Arrays.asList(staticIps));
            return this;
        }

        public final void setStaticIps(Collection<StaticIp> staticIps) {
            this.staticIps = StaticIpListCopier.copy(staticIps);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetStaticIpsResponse build() {
            return new GetStaticIpsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetStaticIpsResponse> {
        public Builder staticIps(Collection<StaticIp> var1);

        public Builder staticIps(StaticIp ... var1);

        public Builder nextPageToken(String var1);
    }
}

