/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Bundle;
import software.amazon.awssdk.services.lightsail.model.BundleListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBundlesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBundlesResponse> {
    private final List<Bundle> bundles;
    private final String nextPageToken;

    private GetBundlesResponse(BuilderImpl builder) {
        this.bundles = builder.bundles;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Bundle> bundles() {
        return this.bundles;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bundles() == null ? 0 : this.bundles().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesResponse)) {
            return false;
        }
        GetBundlesResponse other = (GetBundlesResponse)((Object)obj);
        if (other.bundles() == null ^ this.bundles() == null) {
            return false;
        }
        if (other.bundles() != null && !other.bundles().equals(this.bundles())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bundles() != null) {
            sb.append("Bundles: ").append(this.bundles()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Bundle> bundles;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBundlesResponse model) {
            this.setBundles(model.bundles);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<Bundle> getBundles() {
            return this.bundles;
        }

        @Override
        public final Builder bundles(Collection<Bundle> bundles) {
            this.bundles = BundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Bundle ... bundles) {
            this.bundles(Arrays.asList(bundles));
            return this;
        }

        public final void setBundles(Collection<Bundle> bundles) {
            this.bundles = BundleListCopier.copy(bundles);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetBundlesResponse build() {
            return new GetBundlesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBundlesResponse> {
        public Builder bundles(Collection<Bundle> var1);

        public Builder bundles(Bundle ... var1);

        public Builder nextPageToken(String var1);
    }
}

