/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.KeyPair;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateKeyPairResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateKeyPairResponse> {
    private final KeyPair keyPair;
    private final String publicKeyBase64;
    private final String privateKeyBase64;
    private final Operation operation;

    private CreateKeyPairResponse(BuilderImpl builder) {
        this.keyPair = builder.keyPair;
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
        this.operation = builder.operation;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public String publicKeyBase64() {
        return this.publicKeyBase64;
    }

    public String privateKeyBase64() {
        return this.privateKeyBase64;
    }

    public Operation operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyPair() == null ? 0 : this.keyPair().hashCode());
        hashCode = 31 * hashCode + (this.publicKeyBase64() == null ? 0 : this.publicKeyBase64().hashCode());
        hashCode = 31 * hashCode + (this.privateKeyBase64() == null ? 0 : this.privateKeyBase64().hashCode());
        hashCode = 31 * hashCode + (this.operation() == null ? 0 : this.operation().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairResponse)) {
            return false;
        }
        CreateKeyPairResponse other = (CreateKeyPairResponse)((Object)obj);
        if (other.keyPair() == null ^ this.keyPair() == null) {
            return false;
        }
        if (other.keyPair() != null && !other.keyPair().equals(this.keyPair())) {
            return false;
        }
        if (other.publicKeyBase64() == null ^ this.publicKeyBase64() == null) {
            return false;
        }
        if (other.publicKeyBase64() != null && !other.publicKeyBase64().equals(this.publicKeyBase64())) {
            return false;
        }
        if (other.privateKeyBase64() == null ^ this.privateKeyBase64() == null) {
            return false;
        }
        if (other.privateKeyBase64() != null && !other.privateKeyBase64().equals(this.privateKeyBase64())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        return other.operation() == null || other.operation().equals(this.operation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyPair() != null) {
            sb.append("KeyPair: ").append(this.keyPair()).append(",");
        }
        if (this.publicKeyBase64() != null) {
            sb.append("PublicKeyBase64: ").append(this.publicKeyBase64()).append(",");
        }
        if (this.privateKeyBase64() != null) {
            sb.append("PrivateKeyBase64: ").append(this.privateKeyBase64()).append(",");
        }
        if (this.operation() != null) {
            sb.append("Operation: ").append(this.operation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private KeyPair keyPair;
        private String publicKeyBase64;
        private String privateKeyBase64;
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairResponse model) {
            this.setKeyPair(model.keyPair);
            this.setPublicKeyBase64(model.publicKeyBase64);
            this.setPrivateKeyBase64(model.privateKeyBase64);
            this.setOperation(model.operation);
        }

        public final KeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPublicKeyBase64() {
            return this.publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        public final String getPrivateKeyBase64() {
            return this.privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        public final Operation getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation operation) {
            this.operation = operation;
        }

        public CreateKeyPairResponse build() {
            return new CreateKeyPairResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateKeyPairResponse> {
        public Builder keyPair(KeyPair var1);

        public Builder publicKeyBase64(String var1);

        public Builder privateKeyBase64(String var1);

        public Builder operation(Operation var1);
    }
}

