/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstanceSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
    private final String instanceSnapshotName;
    private final String instanceName;

    private CreateInstanceSnapshotRequest(BuilderImpl builder) {
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.instanceName = builder.instanceName;
    }

    public String instanceSnapshotName() {
        return this.instanceSnapshotName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceSnapshotName() == null ? 0 : this.instanceSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceSnapshotRequest)) {
            return false;
        }
        CreateInstanceSnapshotRequest other = (CreateInstanceSnapshotRequest)((Object)obj);
        if (other.instanceSnapshotName() == null ^ this.instanceSnapshotName() == null) {
            return false;
        }
        if (other.instanceSnapshotName() != null && !other.instanceSnapshotName().equals(this.instanceSnapshotName())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        return other.instanceName() == null || other.instanceName().equals(this.instanceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(this.instanceSnapshotName()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceSnapshotName;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceSnapshotRequest model) {
            this.setInstanceSnapshotName(model.instanceSnapshotName);
            this.setInstanceName(model.instanceName);
        }

        public final String getInstanceSnapshotName() {
            return this.instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public CreateInstanceSnapshotRequest build() {
            return new CreateInstanceSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
        public Builder instanceSnapshotName(String var1);

        public Builder instanceName(String var1);
    }
}

