/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceHardware;
import software.amazon.awssdk.services.lightsail.transform.DiskUnmarshaller;

public class InstanceHardwareUnmarshaller
implements Unmarshaller<InstanceHardware, JsonUnmarshallerContext> {
    private static final InstanceHardwareUnmarshaller INSTANCE = new InstanceHardwareUnmarshaller();

    public InstanceHardware unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceHardware.Builder instanceHardwareBuilder = InstanceHardware.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("cpuCount", targetDepth)) {
                    context.nextToken();
                    instanceHardwareBuilder.cpuCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("disks", targetDepth)) {
                    context.nextToken();
                    instanceHardwareBuilder.disks(new ListUnmarshaller((Unmarshaller)DiskUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ramSizeInGb", targetDepth)) {
                    context.nextToken();
                    instanceHardwareBuilder.ramSizeInGb((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceHardware)instanceHardwareBuilder.build();
    }

    public static InstanceHardwareUnmarshaller getInstance() {
        return INSTANCE;
    }
}

