/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.Blueprint;

@SdkInternalApi
public class BlueprintMarshaller {
    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> GROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("group").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").build();
    private static final MarshallingInfo<Integer> MINPOWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minPower").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> VERSIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionCode").build();
    private static final MarshallingInfo<String> PRODUCTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productUrl").build();
    private static final MarshallingInfo<String> LICENSEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseUrl").build();
    private static final BlueprintMarshaller INSTANCE = new BlueprintMarshaller();

    public static BlueprintMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Blueprint blueprint, ProtocolMarshaller protocolMarshaller) {
        if (blueprint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)blueprint.blueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall((Object)blueprint.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)blueprint.group(), GROUP_BINDING);
            protocolMarshaller.marshall((Object)blueprint.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.isActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.minPower(), MINPOWER_BINDING);
            protocolMarshaller.marshall((Object)blueprint.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)blueprint.versionCode(), VERSIONCODE_BINDING);
            protocolMarshaller.marshall((Object)blueprint.productUrl(), PRODUCTURL_BINDING);
            protocolMarshaller.marshall((Object)blueprint.licenseUrl(), LICENSEURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

