/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PortInfoMarshaller {
    private static final MarshallingInfo<Integer> FROMPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromPort").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("toPort").isBinary(false).build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").isBinary(false).build();
    private static final PortInfoMarshaller INSTANCE = new PortInfoMarshaller();

    private PortInfoMarshaller() {
    }

    public static PortInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PortInfo portInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)portInfo, (String)"portInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)portInfo.fromPort(), FROMPORT_BINDING);
            protocolMarshaller.marshall((Object)portInfo.toPort(), TOPORT_BINDING);
            protocolMarshaller.marshall((Object)portInfo.protocolAsString(), PROTOCOL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

