/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.MonthlyTransfer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MonthlyTransferMarshaller {
    private static final MarshallingInfo<Integer> GBPERMONTHALLOCATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gbPerMonthAllocated").isBinary(false).build();
    private static final MonthlyTransferMarshaller INSTANCE = new MonthlyTransferMarshaller();

    private MonthlyTransferMarshaller() {
    }

    public static MonthlyTransferMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MonthlyTransfer monthlyTransfer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)monthlyTransfer, (String)"monthlyTransfer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)monthlyTransfer.gbPerMonthAllocated(), GBPERMONTHALLOCATED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

